/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v2;

import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="SignatureControllerV2")
@RequestMapping(value={"/pa/signature"})
public class SignatureController {
    private static final Logger logger = LoggerFactory.getLogger(SignatureController.class);

    @RequestMapping(value={"validate"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.DELETE})
    @PowerAuth(resourceId="/pa/signature/validate", signatureType={PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY})
    public Response validateSignature(PowerAuthApiAuthentication auth) throws PowerAuthAuthenticationException {
        if (auth != null && auth.getActivationId() != null) {
            if (!"2.0".equals(auth.getVersion()) && !"2.1".equals(auth.getVersion())) {
                logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)auth.getVersion());
                throw new PowerAuthAuthenticationException();
            }
            return new Response();
        }
        throw new PowerAuthAuthenticationException("Signature validation failed");
    }
}

