/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v2;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.model.request.v2.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.TokenCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.TokenRemoveResponse;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.service.v2.TokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="TokenControllerV2")
@RequestMapping(value={"/pa/token"})
public class TokenController {
    private static final Logger logger = LoggerFactory.getLogger(TokenController.class);
    private TokenService tokenServiceV2;
    private io.getlime.security.powerauth.rest.api.spring.service.v3.TokenService tokenServiceV3;

    @Autowired
    public void setTokenServiceV2(TokenService tokenServiceV2) {
        this.tokenServiceV2 = tokenServiceV2;
    }

    @Autowired
    public void setTokenServiceV3(io.getlime.security.powerauth.rest.api.spring.service.v3.TokenService tokenServiceV3) {
        this.tokenServiceV3 = tokenServiceV3;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @PowerAuth(resourceId="/pa/token/create", signatureType={PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY})
    public ObjectResponse<TokenCreateResponse> createToken(@RequestBody ObjectRequest<TokenCreateRequest> request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        if (request.getRequestObject() == null) {
            logger.warn("Invalid request object in create token");
            throw new PowerAuthAuthenticationException();
        }
        if (authentication != null && authentication.getActivationId() != null) {
            if (!"2.0".equals(authentication.getVersion()) && !"2.1".equals(authentication.getVersion())) {
                logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
                throw new PowerAuthAuthenticationException();
            }
            return new ObjectResponse((Object)this.tokenServiceV2.createToken((TokenCreateRequest)request.getRequestObject(), authentication));
        }
        throw new PowerAuthAuthenticationException();
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST})
    @PowerAuth(resourceId="/pa/token/remove", signatureType={PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY})
    public ObjectResponse<TokenRemoveResponse> removeToken(@RequestBody ObjectRequest<TokenRemoveRequest> request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        if (request.getRequestObject() == null) {
            logger.warn("Invalid request object in create token");
            throw new PowerAuthAuthenticationException();
        }
        if (authentication != null && authentication.getActivationId() != null) {
            if (!"2.0".equals(authentication.getVersion()) && !"2.1".equals(authentication.getVersion())) {
                logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
                throw new PowerAuthAuthenticationException();
            }
            return new ObjectResponse((Object)this.tokenServiceV3.removeToken((TokenRemoveRequest)request.getRequestObject(), authentication));
        }
        throw new PowerAuthAuthenticationException();
    }
}

