/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v3;

import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthEncryptionHttpHeaderValidator;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthUpgradeException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.service.v3.UpgradeService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pa/v3/upgrade"})
public class UpgradeController {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeController.class);
    private UpgradeService upgradeService;

    @Autowired
    public void setUpgradeService(UpgradeService upgradeService) {
        this.upgradeService = upgradeService;
    }

    @RequestMapping(value={"start"}, method={RequestMethod.POST})
    public EciesEncryptedResponse upgradeStart(@RequestBody EciesEncryptedRequest request, @RequestHeader(value="X-PowerAuth-Encryption", defaultValue="unknown") String encryptionHeader) throws PowerAuthUpgradeException {
        if (request == null) {
            logger.warn("Invalid request object in upgrade start");
            throw new PowerAuthUpgradeException();
        }
        PowerAuthEncryptionHttpHeader header = new PowerAuthEncryptionHttpHeader().fromValue(encryptionHeader);
        try {
            PowerAuthEncryptionHttpHeaderValidator.validate((PowerAuthEncryptionHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            throw new PowerAuthUpgradeException(ex.getMessage());
        }
        if (!"3.0".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthUpgradeException();
        }
        return this.upgradeService.upgradeStart(request, header);
    }

    @RequestMapping(value={"commit"}, method={RequestMethod.POST})
    public Response upgradeCommit(@RequestHeader(value="X-PowerAuth-Authorization") String signatureHeader, HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthUpgradeException {
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            throw new PowerAuthUpgradeException(ex.getMessage());
        }
        if (!"3.0".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthAuthenticationException();
        }
        return this.upgradeService.upgradeCommit(signatureHeader, httpServletRequest);
    }
}

