/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v2;

import io.getlime.powerauth.soap.v2.CreateTokenResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.model.request.v2.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.TokenCreateResponse;
import io.getlime.security.powerauth.rest.api.spring.converter.v2.SignatureTypeConverter;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TokenServiceV2")
public class TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private PowerAuthServiceClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    public TokenCreateResponse createToken(TokenCreateRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            String activationId = authentication.getActivationId();
            PowerAuthSignatureTypes signatureFactors = authentication.getSignatureFactors();
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            SignatureTypeConverter converter = new SignatureTypeConverter();
            CreateTokenResponse token = this.powerAuthClient.v2().createToken(activationId, ephemeralPublicKey, converter.convertFrom(signatureFactors));
            TokenCreateResponse response = new TokenCreateResponse();
            response.setMac(token.getMac());
            response.setEncryptedData(token.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth token failed", (Throwable)ex);
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }
}

