/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import io.getlime.powerauth.soap.v3.CreateActivationResponse;
import io.getlime.powerauth.soap.v3.GetActivationStatusResponse;
import io.getlime.powerauth.soap.v3.PrepareActivationResponse;
import io.getlime.powerauth.soap.v3.RemoveActivationResponse;
import io.getlime.security.powerauth.rest.api.base.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.encryption.EciesEncryptionContext;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.provider.CustomActivationProvider;
import io.getlime.security.powerauth.rest.api.model.entity.ActivationType;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ActivationServiceV3")
public class ActivationService {
    private PowerAuthServiceClient powerAuthClient;
    private PowerAuthApplicationConfiguration applicationConfiguration;
    private CustomActivationProvider activationProvider;
    private static final Logger logger = LoggerFactory.getLogger(ActivationService.class);

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired(required=false)
    public void setApplicationConfiguration(PowerAuthApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Autowired(required=false)
    public void setPowerAuthActivationProvider(CustomActivationProvider activationProvider) {
        this.activationProvider = activationProvider;
    }

    public ActivationLayer1Response createActivation(ActivationLayer1Request request, EciesEncryptionContext eciesContext) throws PowerAuthActivationException {
        try {
            String applicationKey = eciesContext.getApplicationKey();
            EciesEncryptedRequest activationData = request.getActivationData();
            String ephemeralPublicKey = activationData.getEphemeralPublicKey();
            String encryptedData = activationData.getEncryptedData();
            String mac = activationData.getMac();
            Map customAttributes = request.getCustomAttributes();
            Map identity = request.getIdentityAttributes();
            switch (request.getType()) {
                case CODE: {
                    String activationCode = (String)request.getIdentityAttributes().get("code");
                    PrepareActivationResponse response = this.powerAuthClient.prepareActivation(activationCode, applicationKey, ephemeralPublicKey, encryptedData, mac);
                    Map processedCustomAttributes = customAttributes;
                    if (this.activationProvider != null) {
                        processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), response.getUserId(), ActivationType.CODE);
                    }
                    EciesEncryptedResponse encryptedResponseL2 = new EciesEncryptedResponse();
                    encryptedResponseL2.setEncryptedData(response.getEncryptedData());
                    encryptedResponseL2.setMac(response.getMac());
                    ActivationLayer1Response responseL1 = new ActivationLayer1Response();
                    responseL1.setCustomAttributes(processedCustomAttributes);
                    responseL1.setActivationData(encryptedResponseL2);
                    return responseL1;
                }
                case CUSTOM: {
                    if (this.activationProvider == null) {
                        throw new PowerAuthActivationException();
                    }
                    String userId = this.activationProvider.lookupUserIdForAttributes(identity);
                    if (userId == null || userId.equals("") || userId.length() > 255) {
                        throw new PowerAuthActivationException();
                    }
                    CreateActivationResponse response = this.powerAuthClient.createActivation(userId, null, null, applicationKey, ephemeralPublicKey, encryptedData, mac);
                    Map processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), userId, ActivationType.CUSTOM);
                    if (this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), userId)) {
                        this.powerAuthClient.commitActivation(response.getActivationId());
                    }
                    EciesEncryptedResponse encryptedActivationData = new EciesEncryptedResponse(response.getEncryptedData(), response.getMac());
                    ActivationLayer1Response responseL1 = new ActivationLayer1Response();
                    responseL1.setCustomAttributes(processedCustomAttributes);
                    responseL1.setActivationData(encryptedActivationData);
                    return responseL1;
                }
            }
            throw new PowerAuthAuthenticationException("Unsupported activation type: " + request.getType());
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth activation failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationStatusResponse getActivationStatus(ActivationStatusRequest request) throws PowerAuthActivationException {
        try {
            String activationId = request.getActivationId();
            GetActivationStatusResponse soapResponse = this.powerAuthClient.getActivationStatus(activationId);
            ActivationStatusResponse response = new ActivationStatusResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedStatusBlob(soapResponse.getEncryptedStatusBlob());
            if (this.applicationConfiguration != null) {
                response.setCustomObject(this.applicationConfiguration.statusServiceCustomObject());
            }
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation status check failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationRemoveResponse removeActivation(PowerAuthApiAuthentication apiAuthentication) throws PowerAuthActivationException {
        try {
            RemoveActivationResponse soapResponse = this.powerAuthClient.removeActivation(apiAuthentication.getActivationId());
            ActivationRemoveResponse response = new ActivationRemoveResponse();
            response.setActivationId(soapResponse.getActivationId());
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation removal failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }
}

