/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.annotation;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.spring.annotation.EncryptedRequestBody;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthEncryption;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuthToken;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthEncryptionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PowerAuthAnnotationInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthAnnotationInterceptor.class);
    private PowerAuthAuthenticationProvider authenticationProvider;
    private PowerAuthEncryptionProvider encryptionProvider;

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    @Autowired
    public void setEncryptionProvider(PowerAuthEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            PowerAuthApiAuthentication authentication;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            PowerAuth powerAuthSignatureAnnotation = (PowerAuth)handlerMethod.getMethodAnnotation(PowerAuth.class);
            PowerAuthToken powerAuthTokenAnnotation = (PowerAuthToken)handlerMethod.getMethodAnnotation(PowerAuthToken.class);
            PowerAuthEncryption powerAuthEncryptionAnnotation = (PowerAuthEncryption)handlerMethod.getMethodAnnotation(PowerAuthEncryption.class);
            if (powerAuthSignatureAnnotation != null && powerAuthTokenAnnotation != null) {
                logger.error("You cannot use both @PowerAuth and @PowerAuthToken on same handler method. We are removing both.");
                powerAuthSignatureAnnotation = null;
                powerAuthTokenAnnotation = null;
            }
            if (powerAuthEncryptionAnnotation != null) {
                Class<?> requestType = this.resolveGenericParameterTypeForEcies(handlerMethod);
                try {
                    this.encryptionProvider.decryptRequest(request, requestType, powerAuthEncryptionAnnotation.scope());
                }
                catch (PowerAuthEncryptionException powerAuthEncryptionException) {
                    // empty catch block
                }
            }
            if (powerAuthSignatureAnnotation != null) {
                try {
                    authentication = this.authenticationProvider.validateRequestSignature(request, powerAuthSignatureAnnotation.resourceId(), request.getHeader("X-PowerAuth-Authorization"), new ArrayList<PowerAuthSignatureTypes>(Arrays.asList(powerAuthSignatureAnnotation.signatureType())));
                    request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
                }
                catch (PowerAuthAuthenticationException ex) {
                    request.setAttribute("X-PowerAuth-Authentication-Object", null);
                }
            }
            if (powerAuthTokenAnnotation != null) {
                try {
                    authentication = this.authenticationProvider.validateToken(request.getHeader("X-PowerAuth-Token"), new ArrayList<PowerAuthSignatureTypes>(Arrays.asList(powerAuthTokenAnnotation.signatureType())));
                    request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
                }
                catch (PowerAuthAuthenticationException ex) {
                    request.setAttribute("X-PowerAuth-Authentication-Object", null);
                }
            }
        }
        return super.preHandle(request, response, handler);
    }

    private Class<?> resolveGenericParameterTypeForEcies(HandlerMethod handlerMethod) {
        for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
            if (!parameter.hasParameterAnnotation(EncryptedRequestBody.class)) continue;
            return parameter.getParameterType();
        }
        return Object.class;
    }
}

