/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.exception;

import io.getlime.core.rest.model.base.response.ErrorResponse;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthRecoveryException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthUpgradeException;
import io.getlime.security.powerauth.rest.api.model.exception.RecoveryErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@Order(value=-100)
public class PowerAuthExceptionHandler {
    public static final int PRECEDENCE = -100;
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthExceptionHandler.class);

    @ExceptionHandler(value={PowerAuthAuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public ErrorResponse handleUnauthorizedException(Exception ex) {
        PowerAuthAuthenticationException paex = (PowerAuthAuthenticationException)((Object)ex);
        logger.error(paex.getMessage(), (Throwable)paex);
        return new ErrorResponse(paex.getDefaultCode(), (Throwable)paex);
    }

    @ExceptionHandler(value={PowerAuthActivationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handleActivationException(Exception ex) {
        PowerAuthActivationException paex = (PowerAuthActivationException)ex;
        logger.error(paex.getMessage(), (Throwable)paex);
        return new ErrorResponse(paex.getDefaultCode(), (Throwable)paex);
    }

    @ExceptionHandler(value={PowerAuthRecoveryException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RecoveryErrorResponse handleRecoveryException(Exception ex) {
        PowerAuthRecoveryException paex = (PowerAuthRecoveryException)ex;
        logger.error(paex.getMessage(), (Throwable)paex);
        return new RecoveryErrorResponse(paex.getErrorCode(), (Throwable)paex, paex.getCurrentRecoveryPukIndex());
    }

    @ExceptionHandler(value={PowerAuthSecureVaultException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handleSecureVaultException(Exception ex) {
        PowerAuthSecureVaultException paex = (PowerAuthSecureVaultException)ex;
        logger.error(paex.getMessage(), (Throwable)paex);
        return new ErrorResponse(paex.getDefaultCode(), (Throwable)paex);
    }

    @ExceptionHandler(value={PowerAuthEncryptionException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handlePowerAuthEncryptionException(Exception ex) {
        PowerAuthEncryptionException paex = (PowerAuthEncryptionException)((Object)ex);
        logger.error(paex.getMessage(), (Throwable)paex);
        return new ErrorResponse(paex.getDefaultCode(), (Throwable)paex);
    }

    @ExceptionHandler(value={PowerAuthUpgradeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handlePowerAuthUpgradeException(Exception ex) {
        PowerAuthUpgradeException pamx = (PowerAuthUpgradeException)ex;
        logger.error(pamx.getMessage(), (Throwable)pamx);
        return new ErrorResponse(pamx.getDefaultCode(), (Throwable)pamx);
    }
}

