/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.provider;

import io.getlime.powerauth.soap.v3.GetEciesDecryptorRequest;
import io.getlime.powerauth.soap.v3.GetEciesDecryptorResponse;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthEciesDecryptorParameters;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.base.provider.PowerAuthEncryptionProviderBase;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PowerAuthEncryptionProvider
extends PowerAuthEncryptionProviderBase {
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthEncryptionProvider.class);
    private PowerAuthServiceClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    public PowerAuthEciesDecryptorParameters getEciesDecryptorParameters(String activationId, String applicationKey, String ephemeralPublicKey) throws PowerAuthEncryptionException {
        try {
            GetEciesDecryptorRequest eciesDecryptorRequest = new GetEciesDecryptorRequest();
            eciesDecryptorRequest.setActivationId(activationId);
            eciesDecryptorRequest.setApplicationKey(applicationKey);
            eciesDecryptorRequest.setEphemeralPublicKey(ephemeralPublicKey);
            GetEciesDecryptorResponse eciesDecryptorResponse = this.powerAuthClient.getEciesDecryptor(eciesDecryptorRequest);
            return new PowerAuthEciesDecryptorParameters(eciesDecryptorResponse.getSecretKey(), eciesDecryptorResponse.getSharedInfo2());
        }
        catch (Exception e) {
            logger.warn("Get Ecies decryptor parameters call failed", (Throwable)e);
            throw new PowerAuthEncryptionException();
        }
    }
}

