/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.encryption;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.powerauth.soap.v2.GetNonPersonalizedEncryptionKeyResponse;
import io.getlime.security.powerauth.rest.api.base.encryption.PowerAuthNonPersonalizedEncryptor;
import io.getlime.security.powerauth.rest.api.model.entity.NonPersonalizedEncryptedPayloadModel;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EncryptorFactory {
    private PowerAuthServiceClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    public PowerAuthNonPersonalizedEncryptor buildNonPersonalizedEncryptor(ObjectRequest<NonPersonalizedEncryptedPayloadModel> object) {
        return this.buildNonPersonalizedEncryptor(((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getApplicationKey(), ((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getSessionIndex(), ((NonPersonalizedEncryptedPayloadModel)object.getRequestObject()).getEphemeralPublicKey());
    }

    public PowerAuthNonPersonalizedEncryptor buildNonPersonalizedEncryptor(String applicationKeyBase64, String sessionIndexBase64, String ephemeralPublicKeyBase64) {
        GetNonPersonalizedEncryptionKeyResponse encryptionKeyResponse = this.powerAuthClient.v2().generateNonPersonalizedE2EEncryptionKey(applicationKeyBase64, ephemeralPublicKeyBase64, sessionIndexBase64);
        return new PowerAuthNonPersonalizedEncryptor(encryptionKeyResponse.getApplicationKey(), encryptionKeyResponse.getEncryptionKey(), encryptionKeyResponse.getEncryptionKeyIndex(), encryptionKeyResponse.getEphemeralPublicKey());
    }
}

