/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v2;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.model.request.v2.VaultUnlockRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.VaultUnlockResponse;
import io.getlime.security.powerauth.rest.api.spring.service.v2.SecureVaultService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="secureVaultControllerV2")
@RequestMapping(value={"/pa/vault"})
public class SecureVaultController {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultController.class);
    private SecureVaultService secureVaultServiceV2;

    @Autowired
    public void setSecureVaultServiceV2(SecureVaultService secureVaultServiceV2) {
        this.secureVaultServiceV2 = secureVaultServiceV2;
    }

    @RequestMapping(value={"unlock"}, method={RequestMethod.POST})
    public ObjectResponse<VaultUnlockResponse> unlockVault(@RequestHeader(value="X-PowerAuth-Authorization", defaultValue="unknown") String signatureHeader, @RequestBody(required=false) ObjectRequest<VaultUnlockRequest> request, HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthSecureVaultException {
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
        if (!"2.0".equals(header.getVersion()) && !"2.1".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthAuthenticationException();
        }
        return new ObjectResponse((Object)this.secureVaultServiceV2.vaultUnlock(signatureHeader, (VaultUnlockRequest)request.getRequestObject(), httpServletRequest));
    }
}

