/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import io.getlime.powerauth.soap.v3.CreateTokenResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.TokenRemoveResponse;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tokenServiceV3")
public class TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private PowerAuthServiceClient powerAuthClient;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    public EciesEncryptedResponse createToken(EciesEncryptedRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            PowerAuthSignatureTypes signatureFactors = authentication.getSignatureFactors();
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            String nonce = request.getNonce();
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = authentication.getActivationId();
            PowerAuthSignatureHttpHeader httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader();
            String applicationKey = httpHeader.getApplicationKey();
            CreateTokenResponse token = this.powerAuthClient.createToken(activationId, applicationKey, ephemeralPublicKey, encryptedData, mac, nonce, converter.convertFrom(signatureFactors));
            EciesEncryptedResponse response = new EciesEncryptedResponse();
            response.setMac(token.getMac());
            response.setEncryptedData(token.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth token failed", (Throwable)ex);
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }

    public TokenRemoveResponse removeToken(TokenRemoveRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            String activationId = authentication.getActivationId();
            String tokenId = request.getTokenId();
            this.powerAuthClient.removeToken(tokenId, activationId);
            TokenRemoveResponse response = new TokenRemoveResponse();
            response.setTokenId(tokenId);
            return response;
        }
        catch (Exception ex) {
            logger.warn("Removing PowerAuth token failed", (Throwable)ex);
            throw new PowerAuthAuthenticationException(ex.getMessage());
        }
    }
}

