/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import io.getlime.core.rest.model.base.response.Response;
import io.getlime.powerauth.soap.v3.CommitUpgradeResponse;
import io.getlime.powerauth.soap.v3.StartUpgradeResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthUpgradeException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="upgradeServiceV3")
public class UpgradeService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeService.class);
    private PowerAuthServiceClient powerAuthClient;
    private PowerAuthAuthenticationProvider authenticationProvider;

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public EciesEncryptedResponse upgradeStart(EciesEncryptedRequest request, PowerAuthEncryptionHttpHeader header) throws PowerAuthUpgradeException {
        try {
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            String nonce = request.getNonce();
            String activationId = header.getActivationId();
            String applicationKey = header.getApplicationKey();
            StartUpgradeResponse upgradeResponse = this.powerAuthClient.startUpgrade(activationId, applicationKey, ephemeralPublicKey, encryptedData, mac, nonce);
            EciesEncryptedResponse response = new EciesEncryptedResponse();
            response.setMac(upgradeResponse.getMac());
            response.setEncryptedData(upgradeResponse.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth upgrade start failed", (Throwable)ex);
            throw new PowerAuthUpgradeException();
        }
    }

    public Response upgradeCommit(String signatureHeader, HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthUpgradeException {
        try {
            PowerAuthSignatureHttpHeader httpHeader;
            String applicationKey;
            byte[] requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(httpServletRequest);
            if (requestBodyBytes == null || requestBodyBytes.length == 0) {
                throw new PowerAuthAuthenticationException();
            }
            List<PowerAuthSignatureTypes> allowedSignatureTypes = Collections.singletonList(PowerAuthSignatureTypes.POSSESSION);
            PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature("POST", requestBodyBytes, "/pa/upgrade/commit", signatureHeader, allowedSignatureTypes, Integer.valueOf(3));
            if (authentication == null || authentication.getActivationId() == null) {
                throw new PowerAuthAuthenticationException();
            }
            String activationId = authentication.getActivationId();
            CommitUpgradeResponse upgradeResponse = this.powerAuthClient.commitUpgrade(activationId, applicationKey = (httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader()).getApplicationKey());
            if (upgradeResponse.isCommitted()) {
                return new Response();
            }
            throw new PowerAuthUpgradeException();
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth upgrade commit failed", (Throwable)ex);
            throw new PowerAuthUpgradeException();
        }
    }
}

