/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import com.google.common.io.BaseEncoding;
import io.getlime.powerauth.soap.v3.SignatureType;
import io.getlime.powerauth.soap.v3.VaultUnlockResponse;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="secureVaultServiceV3")
public class SecureVaultService {
    private PowerAuthServiceClient powerAuthClient;
    private PowerAuthAuthenticationProvider authenticationProvider;
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultService.class);

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public EciesEncryptedResponse vaultUnlock(PowerAuthSignatureHttpHeader header, EciesEncryptedRequest request, HttpServletRequest httpServletRequest) throws PowerAuthSecureVaultException, PowerAuthAuthenticationException {
        try {
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = header.getActivationId();
            String applicationKey = header.getApplicationKey();
            String signature = header.getSignature();
            SignatureType signatureType = converter.convertFrom(header.getSignatureType());
            String signatureVersion = header.getVersion();
            String nonce = header.getNonce();
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            String eciesNonce = request.getNonce();
            byte[] requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(httpServletRequest);
            String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), (byte[])requestBodyBytes);
            VaultUnlockResponse soapResponse = this.powerAuthClient.unlockVault(activationId, applicationKey, signature, signatureType, signatureVersion, data, ephemeralPublicKey, encryptedData, mac, eciesNonce);
            if (!soapResponse.isSignatureValid()) {
                throw new PowerAuthAuthenticationException();
            }
            return new EciesEncryptedResponse(soapResponse.getEncryptedData(), soapResponse.getMac());
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth vault unlock failed", (Throwable)ex);
            throw new PowerAuthSecureVaultException();
        }
    }
}

