/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import io.getlime.powerauth.soap.v3.ActivationStatus;
import io.getlime.powerauth.soap.v3.CommitActivationResponse;
import io.getlime.powerauth.soap.v3.CreateActivationResponse;
import io.getlime.powerauth.soap.v3.GetActivationStatusResponse;
import io.getlime.powerauth.soap.v3.PrepareActivationResponse;
import io.getlime.powerauth.soap.v3.RecoveryCodeActivationResponse;
import io.getlime.powerauth.soap.v3.RemoveActivationResponse;
import io.getlime.security.powerauth.rest.api.base.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.encryption.EciesEncryptionContext;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthRecoveryException;
import io.getlime.security.powerauth.rest.api.base.provider.CustomActivationProvider;
import io.getlime.security.powerauth.rest.api.model.entity.ActivationType;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.soap.spring.client.PowerAuthServiceClient;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapFaultDetailElement;
import org.springframework.ws.soap.client.SoapFaultClientException;
import org.w3c.dom.Node;

@Service(value="activationServiceV3")
public class ActivationService {
    private PowerAuthServiceClient powerAuthClient;
    private PowerAuthApplicationConfiguration applicationConfiguration;
    private CustomActivationProvider activationProvider;
    private static final Logger logger = LoggerFactory.getLogger(ActivationService.class);

    @Autowired
    public void setPowerAuthClient(PowerAuthServiceClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired(required=false)
    public void setApplicationConfiguration(PowerAuthApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Autowired(required=false)
    public void setPowerAuthActivationProvider(CustomActivationProvider activationProvider) {
        this.activationProvider = activationProvider;
    }

    public ActivationLayer1Response createActivation(ActivationLayer1Request request, EciesEncryptionContext eciesContext) throws PowerAuthActivationException, PowerAuthRecoveryException {
        try {
            Map customAttributes;
            String applicationKey = eciesContext.getApplicationKey();
            EciesEncryptedRequest activationData = request.getActivationData();
            String ephemeralPublicKey = activationData.getEphemeralPublicKey();
            String encryptedData = activationData.getEncryptedData();
            String mac = activationData.getMac();
            String nonce = activationData.getNonce();
            Map identity = request.getIdentityAttributes();
            Map map = customAttributes = request.getCustomAttributes() != null ? request.getCustomAttributes() : new HashMap();
            if (nonce == null && !"3.0".equals(eciesContext.getVersion())) {
                throw new PowerAuthActivationException();
            }
            switch (request.getType()) {
                case CODE: {
                    if (identity == null || identity.isEmpty()) {
                        logger.warn("Identity attributes are missing for code activation");
                        throw new PowerAuthActivationException();
                    }
                    String activationCode = (String)identity.get("code");
                    if (activationCode == null || activationCode.isEmpty()) {
                        logger.warn("Activation code is missing");
                        throw new PowerAuthActivationException();
                    }
                    PrepareActivationResponse response = this.powerAuthClient.prepareActivation(activationCode, applicationKey, ephemeralPublicKey, encryptedData, mac, nonce);
                    Map processedCustomAttributes = customAttributes;
                    if (this.activationProvider != null) {
                        processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), response.getUserId(), ActivationType.CODE);
                    }
                    boolean notifyActivationCommit = false;
                    if (response.getActivationStatus() == ActivationStatus.ACTIVE) {
                        notifyActivationCommit = true;
                    } else if (this.activationProvider != null && this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), response.getUserId(), ActivationType.CODE)) {
                        CommitActivationResponse commitResponse = this.powerAuthClient.commitActivation(response.getActivationId(), null);
                        notifyActivationCommit = commitResponse.isActivated();
                    }
                    if (this.activationProvider != null && notifyActivationCommit) {
                        this.activationProvider.activationWasCommitted(identity, customAttributes, response.getActivationId(), response.getUserId(), ActivationType.CODE);
                    }
                    return this.prepareEncryptedResponse(response.getEncryptedData(), response.getMac(), processedCustomAttributes);
                }
                case CUSTOM: {
                    CommitActivationResponse commitResponse;
                    if (this.activationProvider == null) {
                        throw new PowerAuthActivationException();
                    }
                    if (identity == null || identity.isEmpty()) {
                        logger.warn("Identity attributes are missing for custom activation");
                        throw new PowerAuthActivationException();
                    }
                    String userId = this.activationProvider.lookupUserIdForAttributes(identity);
                    if (userId == null || userId.equals("") || userId.length() > 255) {
                        logger.warn("Invalid user ID: {}", (Object)userId);
                        throw new PowerAuthActivationException();
                    }
                    Integer maxFailed = this.activationProvider.getMaxFailedAttemptCount(identity, customAttributes, userId, ActivationType.CUSTOM);
                    Long maxFailedCount = maxFailed == null ? null : Long.valueOf(maxFailed.longValue());
                    Integer activationValidityPeriod = this.activationProvider.getValidityPeriodDuringActivation(identity, customAttributes, userId, ActivationType.CUSTOM);
                    Date activationExpireTimestamp = null;
                    if (activationValidityPeriod != null) {
                        Calendar activationExpiration = GregorianCalendar.getInstance();
                        activationExpiration.add(14, activationValidityPeriod);
                        activationExpireTimestamp = activationExpiration.getTime();
                    }
                    CreateActivationResponse response = this.powerAuthClient.createActivation(userId, activationExpireTimestamp, maxFailedCount, applicationKey, ephemeralPublicKey, encryptedData, mac, nonce);
                    Map processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), userId, ActivationType.CUSTOM);
                    if (this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), userId, ActivationType.CUSTOM) && (commitResponse = this.powerAuthClient.commitActivation(response.getActivationId(), null)).isActivated()) {
                        this.activationProvider.activationWasCommitted(identity, customAttributes, response.getActivationId(), userId, ActivationType.CUSTOM);
                    }
                    EciesEncryptedResponse encryptedActivationData = new EciesEncryptedResponse(response.getEncryptedData(), response.getMac());
                    ActivationLayer1Response responseL1 = new ActivationLayer1Response();
                    responseL1.setCustomAttributes(processedCustomAttributes);
                    responseL1.setActivationData(encryptedActivationData);
                    return responseL1;
                }
                case RECOVERY: {
                    if (identity == null || identity.isEmpty()) {
                        logger.warn("Identity attributes are missing for activation recovery");
                        throw new PowerAuthActivationException();
                    }
                    String recoveryCode = (String)identity.get("recoveryCode");
                    String recoveryPuk = (String)identity.get("puk");
                    if (recoveryCode == null || recoveryCode.isEmpty()) {
                        throw new PowerAuthActivationException();
                    }
                    if (recoveryPuk == null || recoveryPuk.isEmpty()) {
                        throw new PowerAuthActivationException();
                    }
                    Long maxFailedCount = null;
                    if (this.activationProvider != null) {
                        Integer maxFailed = this.activationProvider.getMaxFailedAttemptCount(identity, customAttributes, null, ActivationType.RECOVERY);
                        maxFailedCount = maxFailed == null ? null : Long.valueOf(maxFailed.longValue());
                    }
                    RecoveryCodeActivationResponse response = this.powerAuthClient.createActivationUsingRecoveryCode(recoveryCode, recoveryPuk, applicationKey, maxFailedCount, ephemeralPublicKey, encryptedData, mac, nonce);
                    Map processedCustomAttributes = customAttributes;
                    if (this.activationProvider != null) {
                        processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), response.getUserId(), ActivationType.RECOVERY);
                    }
                    if (this.activationProvider == null || this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), response.getUserId(), ActivationType.RECOVERY)) {
                        CommitActivationResponse commitResponse = this.powerAuthClient.commitActivation(response.getActivationId(), null);
                        if (this.activationProvider != null && commitResponse.isActivated()) {
                            this.activationProvider.activationWasCommitted(identity, customAttributes, response.getActivationId(), response.getUserId(), ActivationType.RECOVERY);
                        }
                    }
                    return this.prepareEncryptedResponse(response.getEncryptedData(), response.getMac(), processedCustomAttributes);
                }
            }
            throw new PowerAuthAuthenticationException("Unsupported activation type: " + request.getType());
        }
        catch (SoapFaultClientException ex) {
            if (ex.getSoapFault() != null && ex.getSoapFault().getFaultDetail() != null) {
                this.handleInvalidRecoveryError(ex.getSoapFault().getFaultDetail());
            }
            logger.warn("Creating PowerAuth activation failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
        catch (PowerAuthActivationException ex) {
            logger.warn("Creating PowerAuth activation failed", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth activation failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationStatusResponse getActivationStatus(ActivationStatusRequest request) throws PowerAuthActivationException {
        try {
            String activationId = request.getActivationId();
            String challenge = request.getChallenge();
            GetActivationStatusResponse soapResponse = this.powerAuthClient.getActivationStatusWithEncryptedStatusBlob(activationId, challenge);
            ActivationStatusResponse response = new ActivationStatusResponse();
            response.setActivationId(soapResponse.getActivationId());
            response.setEncryptedStatusBlob(soapResponse.getEncryptedStatusBlob());
            response.setNonce(soapResponse.getEncryptedStatusBlobNonce());
            if (this.applicationConfiguration != null) {
                response.setCustomObject(this.applicationConfiguration.statusServiceCustomObject());
            }
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation status check failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationRemoveResponse removeActivation(PowerAuthApiAuthentication apiAuthentication) throws PowerAuthActivationException {
        try {
            RemoveActivationResponse soapResponse;
            String activationId = apiAuthentication.getActivationId();
            String userId = apiAuthentication.getUserId();
            Long applicationId = apiAuthentication.getApplicationId();
            if (this.activationProvider != null) {
                boolean revokeCodes = this.activationProvider.shouldRevokeRecoveryCodeOnRemove(activationId, userId, applicationId);
                soapResponse = this.powerAuthClient.removeActivation(activationId, null, Boolean.valueOf(revokeCodes));
                this.activationProvider.activationWasRemoved(activationId, userId, applicationId);
            } else {
                soapResponse = this.powerAuthClient.removeActivation(activationId, null);
            }
            ActivationRemoveResponse response = new ActivationRemoveResponse();
            response.setActivationId(soapResponse.getActivationId());
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation removal failed", (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    private void handleInvalidRecoveryError(SoapFaultDetail faultDetail) throws PowerAuthRecoveryException {
        String errorCode = null;
        String errorMessage = null;
        Integer currentRecoveryPukIndex = null;
        Iterator iter = faultDetail.getDetailEntries();
        while (iter.hasNext()) {
            SoapFaultDetailElement detail = (SoapFaultDetailElement)iter.next();
            Node node = ((DOMSource)detail.getSource()).getNode();
            switch (node.getLocalName()) {
                case "errorCode": {
                    errorCode = node.getTextContent();
                    break;
                }
                case "localizedMessage": {
                    errorMessage = node.getTextContent();
                    break;
                }
                case "currentRecoveryPukIndex": {
                    try {
                        currentRecoveryPukIndex = Integer.parseInt(node.getTextContent());
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ("ERR0028".equals(errorCode)) {
            throw new PowerAuthRecoveryException(errorMessage, "INVALID_RECOVERY_CODE", currentRecoveryPukIndex);
        }
    }

    private ActivationLayer1Response prepareEncryptedResponse(String encryptedData, String mac, Map<String, Object> processedCustomAttributes) {
        EciesEncryptedResponse encryptedResponseL2 = new EciesEncryptedResponse();
        encryptedResponseL2.setEncryptedData(encryptedData);
        encryptedResponseL2.setMac(mac);
        ActivationLayer1Response responseL1 = new ActivationLayer1Response();
        responseL1.setCustomAttributes(processedCustomAttributes);
        responseL1.setActivationData(encryptedResponseL2);
        return responseL1;
    }
}

