/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v3;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthInvalidRequestException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.TokenRemoveResponse;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.service.v3.TokenService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="tokenControllerV3")
@RequestMapping(value={"/pa/v3/token"})
public class TokenController {
    private static final Logger logger = LoggerFactory.getLogger(TokenController.class);
    private TokenService tokenServiceV3;

    @Autowired
    public void setTokenServiceV3(TokenService tokenServiceV3) {
        this.tokenServiceV3 = tokenServiceV3;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @PowerAuth(resourceId="/pa/token/create", signatureType={PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY})
    public EciesEncryptedResponse createToken(@RequestBody EciesEncryptedRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        if (request == null) {
            logger.warn("Invalid request object in create token");
            throw new PowerAuthInvalidRequestException();
        }
        if (authentication == null || authentication.getActivationId() == null) {
            logger.debug("Signature validation failed");
            throw new PowerAuthSignatureInvalidException();
        }
        if (!"3.0".equals(authentication.getVersion()) && !"3.1".equals(authentication.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
            throw new PowerAuthInvalidRequestException();
        }
        if (request.getNonce() == null && !"3.0".equals(authentication.getVersion())) {
            logger.warn("Missing nonce in ECIES request data");
            throw new PowerAuthInvalidRequestException();
        }
        return this.tokenServiceV3.createToken(request, authentication);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST})
    @PowerAuth(resourceId="/pa/token/remove", signatureType={PowerAuthSignatureTypes.POSSESSION, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE, PowerAuthSignatureTypes.POSSESSION_BIOMETRY, PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE_BIOMETRY})
    public ObjectResponse<TokenRemoveResponse> removeToken(@RequestBody ObjectRequest<TokenRemoveRequest> request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        if (request.getRequestObject() == null) {
            logger.warn("Invalid request object in remove token");
            throw new PowerAuthInvalidRequestException();
        }
        if (authentication == null || authentication.getActivationId() == null) {
            throw new PowerAuthSignatureInvalidException();
        }
        if (!"3.0".equals(authentication.getVersion()) && !"3.1".equals(authentication.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
            throw new PowerAuthInvalidRequestException();
        }
        TokenRemoveResponse response = this.tokenServiceV3.removeToken((TokenRemoveRequest)request.getRequestObject(), authentication);
        return new ObjectResponse((Object)response);
    }
}

