/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v2;

import com.google.common.io.BaseEncoding;
import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.v2.SignatureType;
import io.getlime.security.powerauth.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthSignatureTypeInvalidException;
import io.getlime.security.powerauth.rest.api.model.request.v2.VaultUnlockRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.VaultUnlockResponse;
import io.getlime.security.powerauth.rest.api.spring.converter.v2.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="secureVaultServiceV2")
public class SecureVaultService {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultService.class);
    private PowerAuthClient powerAuthClient;
    private PowerAuthAuthenticationProvider authenticationProvider;

    @Autowired
    public void setPowerAuthClient(PowerAuthClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    public VaultUnlockResponse vaultUnlock(String signatureHeader, VaultUnlockRequest request, HttpServletRequest httpServletRequest) throws PowerAuthSecureVaultException, PowerAuthAuthenticationException {
        try {
            byte[] requestBodyBytes;
            PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
            try {
                PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
            }
            catch (InvalidPowerAuthHttpHeaderException ex) {
                logger.warn("Signature HTTP header validation failed, error: {}", (Object)ex.getMessage());
                logger.debug(ex.getMessage(), (Throwable)ex);
                throw new PowerAuthSignatureTypeInvalidException();
            }
            SignatureTypeConverter converter = new SignatureTypeConverter();
            String activationId = header.getActivationId();
            String applicationId = header.getApplicationKey();
            String signature = header.getSignature();
            SignatureType signatureType = converter.convertFrom(header.getSignatureType());
            if (signatureType == null) {
                logger.warn("Invalid signature type: {}", (Object)header.getSignatureType());
                throw new PowerAuthSignatureTypeInvalidException();
            }
            String nonce = header.getNonce();
            String reason = null;
            if ("2.0".equals(header.getVersion())) {
                requestBodyBytes = null;
            } else if ("2.1".equals(header.getVersion())) {
                if (request != null && request.getReason() != null) {
                    reason = request.getReason();
                }
                requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(httpServletRequest);
            } else {
                logger.warn("Invalid protocol version in secure vault: {}", (Object)header.getVersion());
                throw new PowerAuthSecureVaultException();
            }
            String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), requestBodyBytes);
            com.wultra.security.powerauth.client.v2.VaultUnlockResponse paResponse = this.powerAuthClient.v2().unlockVault(activationId, applicationId, data, signature, signatureType, reason);
            if (!paResponse.isSignatureValid()) {
                logger.debug("Signature validation failed");
                throw new PowerAuthSignatureInvalidException();
            }
            VaultUnlockResponse response = new VaultUnlockResponse();
            response.setActivationId(paResponse.getActivationId());
            response.setEncryptedVaultEncryptionKey(paResponse.getEncryptedVaultEncryptionKey());
            return response;
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth vault unlock failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthSecureVaultException();
        }
    }
}

