/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.v3.ConfirmRecoveryCodeResponse;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthInvalidRequestException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthRecoveryConfirmationException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RecoveryService {
    private static final Logger logger = LoggerFactory.getLogger(RecoveryService.class);
    private final PowerAuthClient powerAuthClient;

    @Autowired
    public RecoveryService(PowerAuthClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    public EciesEncryptedResponse confirmRecoveryCode(EciesEncryptedRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            String activationId = authentication.getActivationId();
            PowerAuthSignatureHttpHeader httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader();
            String applicationKey = httpHeader.getApplicationKey();
            if (activationId == null || applicationKey == null || request.getEphemeralPublicKey() == null || request.getEncryptedData() == null || request.getMac() == null) {
                logger.warn("PowerAuth confirm recovery failed because of invalid request");
                throw new PowerAuthInvalidRequestException();
            }
            ConfirmRecoveryCodeResponse paResponse = this.powerAuthClient.confirmRecoveryCode(activationId, applicationKey, request.getEphemeralPublicKey(), request.getEncryptedData(), request.getMac(), request.getNonce());
            if (!paResponse.getActivationId().equals(activationId)) {
                logger.warn("PowerAuth confirm recovery failed because of invalid activation ID in response");
                throw new PowerAuthInvalidRequestException();
            }
            return new EciesEncryptedResponse(paResponse.getEncryptedData(), paResponse.getMac());
        }
        catch (Exception ex) {
            logger.warn("PowerAuth confirm recovery failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthRecoveryConfirmationException();
        }
    }
}

