/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v2;

import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthInvalidRequestException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.spring.service.v2.ActivationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="activationControllerV2")
@RequestMapping(value={"/pa/activation"})
public class ActivationController {
    private static final Logger logger = LoggerFactory.getLogger(ActivationController.class);
    private ActivationService activationServiceV2;
    private io.getlime.security.powerauth.rest.api.spring.service.v3.ActivationService activationServiceV3;
    private PowerAuthAuthenticationProvider authenticationProvider;

    @Autowired
    public void setActivationServiceV2(ActivationService activationServiceV2) {
        this.activationServiceV2 = activationServiceV2;
    }

    @Autowired
    public void setActivationServiceV3(io.getlime.security.powerauth.rest.api.spring.service.v3.ActivationService activationServiceV3) {
        this.activationServiceV3 = activationServiceV3;
    }

    @Autowired
    public void setAuthenticationProvider(PowerAuthAuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public ObjectResponse<ActivationCreateResponse> createActivation(@RequestBody ObjectRequest<ActivationCreateRequest> request) throws PowerAuthActivationException {
        if (request.getRequestObject() == null || ((ActivationCreateRequest)request.getRequestObject()).getActivationIdShort() == null) {
            logger.warn("Invalid request object in activation create");
            throw new PowerAuthActivationException();
        }
        ActivationCreateResponse response = this.activationServiceV2.createActivation((ActivationCreateRequest)request.getRequestObject());
        return new ObjectResponse((Object)response);
    }

    @RequestMapping(value={"status"}, method={RequestMethod.POST})
    public ObjectResponse<ActivationStatusResponse> getActivationStatus(@RequestBody ObjectRequest<ActivationStatusRequest> request) throws PowerAuthActivationException {
        if (request.getRequestObject() == null || ((ActivationStatusRequest)request.getRequestObject()).getActivationId() == null) {
            logger.warn("Invalid request object in activation status");
            throw new PowerAuthActivationException();
        }
        ActivationStatusResponse response = this.activationServiceV3.getActivationStatus((ActivationStatusRequest)request.getRequestObject());
        return new ObjectResponse((Object)response);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST})
    public ObjectResponse<ActivationRemoveResponse> removeActivation(@RequestHeader(value="X-PowerAuth-Authorization") String signatureHeader) throws PowerAuthActivationException, PowerAuthAuthenticationException {
        PowerAuthApiAuthentication apiAuthentication = this.authenticationProvider.validateRequestSignature("POST", null, "/pa/activation/remove", signatureHeader);
        if (apiAuthentication == null || apiAuthentication.getActivationId() == null) {
            logger.debug("Signature validation failed");
            throw new PowerAuthSignatureInvalidException();
        }
        if (!"2.0".equals(apiAuthentication.getVersion()) && !"2.1".equals(apiAuthentication.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)apiAuthentication.getVersion());
            throw new PowerAuthInvalidRequestException();
        }
        ActivationRemoveResponse response = this.activationServiceV3.removeActivation(apiAuthentication);
        return new ObjectResponse((Object)response);
    }
}

