/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v3;

import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.base.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthInvalidRequestException;
import io.getlime.security.powerauth.rest.api.base.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.annotation.PowerAuth;
import io.getlime.security.powerauth.rest.api.spring.service.v3.RecoveryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pa/v3/recovery"})
public class RecoveryController {
    private static final Logger logger = LoggerFactory.getLogger(RecoveryController.class);
    private final RecoveryService recoveryService;

    public RecoveryController(RecoveryService recoveryService) {
        this.recoveryService = recoveryService;
    }

    @RequestMapping(value={"confirm"}, method={RequestMethod.POST})
    @PowerAuth(resourceId="/pa/recovery/confirm", signatureType={PowerAuthSignatureTypes.POSSESSION_KNOWLEDGE})
    public EciesEncryptedResponse confirmRecoveryCode(@RequestBody EciesEncryptedRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        if (request == null) {
            logger.warn("Invalid request object in confirm recovery");
            throw new PowerAuthInvalidRequestException();
        }
        if (authentication == null || authentication.getActivationId() == null) {
            throw new PowerAuthSignatureInvalidException();
        }
        if (!"3.0".equals(authentication.getVersion()) && !"3.1".equals(authentication.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)authentication.getVersion());
            throw new PowerAuthInvalidRequestException();
        }
        if (request.getNonce() == null && !"3.0".equals(authentication.getVersion())) {
            logger.warn("Missing nonce in ECIES request data");
            throw new PowerAuthInvalidRequestException();
        }
        return this.recoveryService.confirmRecoveryCode(request, authentication);
    }
}

