/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.exception;

import io.getlime.core.rest.model.base.response.ErrorResponse;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthEncryptionException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthRecoveryException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthUpgradeException;
import io.getlime.security.powerauth.rest.api.model.exception.RecoveryErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
@Order(value=-100)
public class PowerAuthExceptionHandler {
    public static final int PRECEDENCE = -100;
    private static final Logger logger = LoggerFactory.getLogger(PowerAuthExceptionHandler.class);

    @ExceptionHandler(value={PowerAuthAuthenticationException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ResponseBody
    public ErrorResponse handleUnauthorizedException(PowerAuthAuthenticationException ex) {
        logger.warn(ex.getMessage(), (Throwable)ex);
        return new ErrorResponse(ex.getDefaultCode(), ex.getDefaultError());
    }

    @ExceptionHandler(value={PowerAuthActivationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handleActivationException(PowerAuthActivationException ex) {
        logger.warn(ex.getMessage(), (Throwable)ex);
        return new ErrorResponse(ex.getDefaultCode(), ex.getDefaultError());
    }

    @ExceptionHandler(value={PowerAuthRecoveryException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public RecoveryErrorResponse handleRecoveryException(PowerAuthRecoveryException ex) {
        logger.warn(ex.getMessage(), (Throwable)ex);
        return new RecoveryErrorResponse(ex.getErrorCode(), ex.getDefaultError(), ex.getCurrentRecoveryPukIndex());
    }

    @ExceptionHandler(value={PowerAuthSecureVaultException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handleSecureVaultException(PowerAuthSecureVaultException ex) {
        logger.warn(ex.getMessage(), (Throwable)ex);
        return new ErrorResponse(ex.getDefaultCode(), ex.getDefaultError());
    }

    @ExceptionHandler(value={PowerAuthEncryptionException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handlePowerAuthEncryptionException(PowerAuthEncryptionException ex) {
        logger.warn(ex.getMessage(), (Throwable)ex);
        return new ErrorResponse(ex.getDefaultCode(), ex.getDefaultError());
    }

    @ExceptionHandler(value={PowerAuthUpgradeException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorResponse handlePowerAuthUpgradeException(PowerAuthUpgradeException ex) {
        logger.warn(ex.getMessage(), (Throwable)ex);
        return new ErrorResponse(ex.getDefaultCode(), ex.getDefaultError());
    }
}

