/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v2;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.v2.PrepareActivationResponse;
import io.getlime.security.powerauth.rest.api.base.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.model.request.v2.ActivationCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.ActivationCreateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="activationServiceV2")
public class ActivationService {
    private PowerAuthClient powerAuthClient;
    private static final Logger logger = LoggerFactory.getLogger(ActivationService.class);

    @Autowired
    public void setPowerAuthClient(PowerAuthClient powerAuthClient) {
        this.powerAuthClient = powerAuthClient;
    }

    public ActivationCreateResponse createActivation(ActivationCreateRequest request) throws PowerAuthActivationException {
        try {
            String activationIDShort = request.getActivationIdShort();
            String activationNonce = request.getActivationNonce();
            String cDevicePublicKey = request.getEncryptedDevicePublicKey();
            String activationName = request.getActivationName();
            String extras = request.getExtras();
            String applicationKey = request.getApplicationKey();
            String applicationSignature = request.getApplicationSignature();
            String clientEphemeralKey = request.getEphemeralPublicKey();
            PrepareActivationResponse paResponse = this.powerAuthClient.v2().prepareActivation(activationIDShort, activationName, activationNonce, clientEphemeralKey, cDevicePublicKey, extras, applicationKey, applicationSignature);
            ActivationCreateResponse response = new ActivationCreateResponse();
            response.setActivationId(paResponse.getActivationId());
            response.setActivationNonce(paResponse.getActivationNonce());
            response.setEncryptedServerPublicKey(paResponse.getEncryptedServerPublicKey());
            response.setEncryptedServerPublicKeySignature(paResponse.getEncryptedServerPublicKeySignature());
            response.setEphemeralPublicKey(paResponse.getEphemeralPublicKey());
            return response;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth activation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }
}

