/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.controller.v3;

import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.http.validator.InvalidPowerAuthHttpHeaderException;
import io.getlime.security.powerauth.http.validator.PowerAuthSignatureHttpHeaderValidator;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthSecureVaultException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthInvalidRequestException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.spring.service.v3.SecureVaultService;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="secureVaultControllerV3")
@RequestMapping(value={"/pa/v3/vault"})
public class SecureVaultController {
    private static final Logger logger = LoggerFactory.getLogger(SecureVaultController.class);
    private SecureVaultService secureVaultServiceV3;

    @Autowired
    public void setSecureVaultServiceV3(SecureVaultService secureVaultServiceV3) {
        this.secureVaultServiceV3 = secureVaultServiceV3;
    }

    @RequestMapping(value={"unlock"}, method={RequestMethod.POST})
    public EciesEncryptedResponse unlockVault(@RequestHeader(value="X-PowerAuth-Authorization", defaultValue="unknown") String signatureHeader, @RequestBody EciesEncryptedRequest request, HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthSecureVaultException {
        if (request == null) {
            logger.warn("Invalid request object in vault unlock");
            throw new PowerAuthInvalidRequestException();
        }
        PowerAuthSignatureHttpHeader header = new PowerAuthSignatureHttpHeader().fromValue(signatureHeader);
        try {
            PowerAuthSignatureHttpHeaderValidator.validate((PowerAuthSignatureHttpHeader)header);
        }
        catch (InvalidPowerAuthHttpHeaderException ex) {
            logger.warn("Signature HTTP header validation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthSignatureInvalidException();
        }
        if (!"3.0".equals(header.getVersion()) && !"3.1".equals(header.getVersion())) {
            logger.warn("Endpoint does not support PowerAuth protocol version {}", (Object)header.getVersion());
            throw new PowerAuthInvalidRequestException();
        }
        if (request.getNonce() == null && !"3.0".equals(header.getVersion())) {
            logger.warn("Missing nonce in ECIES request data");
            throw new PowerAuthInvalidRequestException();
        }
        return this.secureVaultServiceV3.vaultUnlock(header, request, httpServletRequest);
    }
}

