/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v2;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.v2.CreateTokenRequest;
import com.wultra.security.powerauth.client.v2.CreateTokenResponse;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.rest.api.model.request.v2.TokenCreateRequest;
import io.getlime.security.powerauth.rest.api.model.response.v2.TokenCreateResponse;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.spring.converter.v2.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthTokenErrorException;
import io.getlime.security.powerauth.rest.api.spring.service.HttpCustomizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tokenServiceV2")
public class TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private final PowerAuthClient powerAuthClient;
    private final HttpCustomizationService httpCustomizationService;

    @Autowired
    public TokenService(PowerAuthClient powerAuthClient, HttpCustomizationService httpCustomizationService) {
        this.powerAuthClient = powerAuthClient;
        this.httpCustomizationService = httpCustomizationService;
    }

    public TokenCreateResponse createToken(TokenCreateRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            String activationId = authentication.getActivationContext().getActivationId();
            PowerAuthSignatureTypes signatureFactors = authentication.getAuthenticationContext().getSignatureType();
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            SignatureTypeConverter converter = new SignatureTypeConverter();
            CreateTokenRequest tokenRequest = new CreateTokenRequest();
            tokenRequest.setActivationId(activationId);
            tokenRequest.setEphemeralPublicKey(ephemeralPublicKey);
            tokenRequest.setSignatureType(converter.convertFrom(signatureFactors));
            CreateTokenResponse token = this.powerAuthClient.v2().createToken(tokenRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            TokenCreateResponse response = new TokenCreateResponse();
            response.setMac(token.getMac());
            response.setEncryptedData(token.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth token failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthTokenErrorException();
        }
    }
}

