/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.model.error.PowerAuthClientException;
import com.wultra.security.powerauth.client.model.error.PowerAuthErrorRecovery;
import com.wultra.security.powerauth.client.v3.ActivationStatus;
import com.wultra.security.powerauth.client.v3.AddActivationFlagsRequest;
import com.wultra.security.powerauth.client.v3.CommitActivationRequest;
import com.wultra.security.powerauth.client.v3.CommitActivationResponse;
import com.wultra.security.powerauth.client.v3.CreateActivationRequest;
import com.wultra.security.powerauth.client.v3.CreateActivationResponse;
import com.wultra.security.powerauth.client.v3.GetActivationStatusRequest;
import com.wultra.security.powerauth.client.v3.GetActivationStatusResponse;
import com.wultra.security.powerauth.client.v3.PrepareActivationRequest;
import com.wultra.security.powerauth.client.v3.PrepareActivationResponse;
import com.wultra.security.powerauth.client.v3.RecoveryCodeActivationRequest;
import com.wultra.security.powerauth.client.v3.RecoveryCodeActivationResponse;
import com.wultra.security.powerauth.client.v3.RemoveActivationRequest;
import com.wultra.security.powerauth.client.v3.RemoveActivationResponse;
import io.getlime.security.powerauth.rest.api.model.entity.ActivationType;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationLayer1Request;
import io.getlime.security.powerauth.rest.api.model.request.v3.ActivationStatusRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationLayer1Response;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationRemoveResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.ActivationStatusResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.application.PowerAuthApplicationConfiguration;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.ActivationContextConverter;
import io.getlime.security.powerauth.rest.api.spring.encryption.EciesEncryptionContext;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthActivationException;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthRecoveryException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthInvalidRequestException;
import io.getlime.security.powerauth.rest.api.spring.model.ActivationContext;
import io.getlime.security.powerauth.rest.api.spring.provider.CustomActivationProvider;
import io.getlime.security.powerauth.rest.api.spring.service.HttpCustomizationService;
import java.time.Instant;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="activationServiceV3")
public class ActivationService {
    private static final Logger logger = LoggerFactory.getLogger(ActivationService.class);
    private final PowerAuthClient powerAuthClient;
    private final HttpCustomizationService httpCustomizationService;
    private final ActivationContextConverter activationContextConverter;
    private PowerAuthApplicationConfiguration applicationConfiguration;
    private CustomActivationProvider activationProvider;

    @Autowired
    public ActivationService(PowerAuthClient powerAuthClient, HttpCustomizationService httpCustomizationService, ActivationContextConverter activationContextConverter) {
        this.powerAuthClient = powerAuthClient;
        this.httpCustomizationService = httpCustomizationService;
        this.activationContextConverter = activationContextConverter;
    }

    @Autowired(required=false)
    public void setApplicationConfiguration(PowerAuthApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Autowired(required=false)
    public void setPowerAuthActivationProvider(CustomActivationProvider activationProvider) {
        this.activationProvider = activationProvider;
    }

    public ActivationLayer1Response createActivation(ActivationLayer1Request request, EciesEncryptionContext eciesContext) throws PowerAuthActivationException, PowerAuthRecoveryException {
        try {
            Map customAttributes;
            String applicationKey = eciesContext.getApplicationKey();
            EciesEncryptedRequest activationData = request.getActivationData();
            String ephemeralPublicKey = activationData.getEphemeralPublicKey();
            String encryptedData = activationData.getEncryptedData();
            String mac = activationData.getMac();
            String nonce = activationData.getNonce();
            Map identity = request.getIdentityAttributes();
            Map map = customAttributes = request.getCustomAttributes() != null ? request.getCustomAttributes() : new HashMap();
            if (nonce == null && !"3.0".equals(eciesContext.getVersion())) {
                logger.warn("Missing nonce for protocol version: {}", (Object)eciesContext.getVersion());
                throw new PowerAuthActivationException();
            }
            switch (request.getType()) {
                case CODE: {
                    List activationFlags;
                    if (identity == null || identity.isEmpty()) {
                        logger.warn("Identity attributes are missing for code activation");
                        throw new PowerAuthActivationException();
                    }
                    String activationCode = (String)identity.get("code");
                    if (activationCode == null || activationCode.isEmpty()) {
                        logger.warn("Activation code is missing");
                        throw new PowerAuthActivationException();
                    }
                    LinkedHashMap context = new LinkedHashMap();
                    Boolean shouldGenerateRecoveryCodes = null;
                    if (this.activationProvider != null) {
                        shouldGenerateRecoveryCodes = this.activationProvider.shouldCreateRecoveryCodes(identity, customAttributes, ActivationType.CODE, context);
                    }
                    PrepareActivationRequest prepareRequest = new PrepareActivationRequest();
                    prepareRequest.setActivationCode(activationCode);
                    prepareRequest.setApplicationKey(applicationKey);
                    prepareRequest.setGenerateRecoveryCodes(shouldGenerateRecoveryCodes);
                    prepareRequest.setEphemeralPublicKey(ephemeralPublicKey);
                    prepareRequest.setEncryptedData(encryptedData);
                    prepareRequest.setMac(mac);
                    prepareRequest.setNonce(nonce);
                    PrepareActivationResponse response = this.powerAuthClient.prepareActivation(prepareRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                    Map processedCustomAttributes = customAttributes;
                    if (this.activationProvider != null && (activationFlags = this.activationProvider.getActivationFlags(identity, processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), response.getUserId(), response.getApplicationId(), ActivationType.CODE, context), response.getActivationId(), response.getUserId(), response.getApplicationId(), ActivationType.CODE, context)) != null && !activationFlags.isEmpty()) {
                        AddActivationFlagsRequest flagsRequest = new AddActivationFlagsRequest();
                        flagsRequest.setActivationId(response.getActivationId());
                        flagsRequest.getActivationFlags().addAll(activationFlags);
                        this.powerAuthClient.addActivationFlags(flagsRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                    }
                    boolean notifyActivationCommit = false;
                    if (response.getActivationStatus() == ActivationStatus.ACTIVE) {
                        notifyActivationCommit = true;
                    } else if (this.activationProvider != null && this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), response.getUserId(), response.getApplicationId(), ActivationType.CODE, context)) {
                        CommitActivationRequest commitRequest = new CommitActivationRequest();
                        commitRequest.setActivationId(response.getActivationId());
                        commitRequest.setExternalUserId(null);
                        CommitActivationResponse commitResponse = this.powerAuthClient.commitActivation(commitRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                        notifyActivationCommit = commitResponse.isActivated();
                    }
                    if (this.activationProvider != null && notifyActivationCommit) {
                        this.activationProvider.activationWasCommitted(identity, customAttributes, response.getActivationId(), response.getUserId(), response.getApplicationId(), ActivationType.CODE, context);
                    }
                    return this.prepareEncryptedResponse(response.getEncryptedData(), response.getMac(), processedCustomAttributes);
                }
                case CUSTOM: {
                    if (this.activationProvider == null) {
                        logger.warn("Activation provider is not available");
                        throw new PowerAuthActivationException();
                    }
                    if (identity == null || identity.isEmpty()) {
                        logger.warn("Identity attributes are missing for custom activation");
                        throw new PowerAuthActivationException();
                    }
                    LinkedHashMap context = new LinkedHashMap();
                    String userId = this.activationProvider.lookupUserIdForAttributes(identity, context);
                    if (userId == null || userId.equals("") || userId.length() > 255) {
                        logger.warn("Invalid user ID: {}", (Object)userId);
                        throw new PowerAuthActivationException();
                    }
                    Boolean shouldGenerateRecoveryCodes = this.activationProvider.shouldCreateRecoveryCodes(identity, customAttributes, ActivationType.CODE, context);
                    Integer maxFailed = this.activationProvider.getMaxFailedAttemptCount(identity, customAttributes, userId, ActivationType.CUSTOM, context);
                    Long maxFailedCount = maxFailed == null ? null : Long.valueOf(maxFailed.longValue());
                    Long activationValidityPeriod = this.activationProvider.getValidityPeriodDuringActivation(identity, customAttributes, userId, ActivationType.CUSTOM, context);
                    XMLGregorianCalendar activationExpireXml = null;
                    if (activationValidityPeriod != null) {
                        Instant now = Instant.now();
                        Instant expiration = now.plusMillis(activationValidityPeriod);
                        GregorianCalendar c = new GregorianCalendar();
                        c.setTimeInMillis(expiration.toEpochMilli());
                        activationExpireXml = DatatypeFactory.newInstance().newXMLGregorianCalendar(c);
                    }
                    CreateActivationRequest createRequest = new CreateActivationRequest();
                    createRequest.setUserId(userId);
                    createRequest.setTimestampActivationExpire(activationExpireXml);
                    createRequest.setGenerateRecoveryCodes(shouldGenerateRecoveryCodes);
                    createRequest.setMaxFailureCount(maxFailedCount);
                    createRequest.setApplicationKey(applicationKey);
                    createRequest.setEphemeralPublicKey(ephemeralPublicKey);
                    createRequest.setEncryptedData(encryptedData);
                    createRequest.setMac(mac);
                    createRequest.setNonce(nonce);
                    CreateActivationResponse response = this.powerAuthClient.createActivation(createRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                    Map processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, response.getActivationId(), userId, response.getApplicationId(), ActivationType.CUSTOM, context);
                    List activationFlags = this.activationProvider.getActivationFlags(identity, processedCustomAttributes, response.getActivationId(), userId, response.getApplicationId(), ActivationType.CUSTOM, context);
                    if (activationFlags != null && !activationFlags.isEmpty()) {
                        AddActivationFlagsRequest flagsRequest = new AddActivationFlagsRequest();
                        flagsRequest.setActivationId(response.getActivationId());
                        flagsRequest.getActivationFlags().addAll(activationFlags);
                        this.powerAuthClient.addActivationFlags(flagsRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                    }
                    if (this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, response.getActivationId(), userId, response.getApplicationId(), ActivationType.CUSTOM, context)) {
                        CommitActivationRequest commitRequest = new CommitActivationRequest();
                        commitRequest.setActivationId(response.getActivationId());
                        commitRequest.setExternalUserId(null);
                        CommitActivationResponse commitResponse = this.powerAuthClient.commitActivation(commitRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                        if (commitResponse.isActivated()) {
                            this.activationProvider.activationWasCommitted(identity, customAttributes, response.getActivationId(), userId, response.getApplicationId(), ActivationType.CUSTOM, context);
                        }
                    }
                    EciesEncryptedResponse encryptedActivationData = new EciesEncryptedResponse(response.getEncryptedData(), response.getMac());
                    ActivationLayer1Response responseL1 = new ActivationLayer1Response();
                    responseL1.setCustomAttributes(processedCustomAttributes);
                    responseL1.setActivationData(encryptedActivationData);
                    return responseL1;
                }
                case RECOVERY: {
                    List activationFlags;
                    if (identity == null || identity.isEmpty()) {
                        logger.warn("Identity attributes are missing for activation recovery");
                        throw new PowerAuthActivationException();
                    }
                    String recoveryCode = (String)identity.get("recoveryCode");
                    String recoveryPuk = (String)identity.get("puk");
                    if (recoveryCode == null || recoveryCode.isEmpty()) {
                        logger.warn("Recovery code is missing");
                        throw new PowerAuthActivationException();
                    }
                    if (recoveryPuk == null || recoveryPuk.isEmpty()) {
                        logger.warn("Recovery PUK is missing");
                        throw new PowerAuthActivationException();
                    }
                    LinkedHashMap context = new LinkedHashMap();
                    Long maxFailedCount = null;
                    Boolean shouldGenerateRecoveryCodes = null;
                    if (this.activationProvider != null) {
                        Integer maxFailed = this.activationProvider.getMaxFailedAttemptCount(identity, customAttributes, null, ActivationType.RECOVERY, context);
                        maxFailedCount = maxFailed == null ? null : Long.valueOf(maxFailed.longValue());
                        shouldGenerateRecoveryCodes = this.activationProvider.shouldCreateRecoveryCodes(identity, customAttributes, ActivationType.CODE, context);
                    }
                    RecoveryCodeActivationRequest recoveryRequest = new RecoveryCodeActivationRequest();
                    recoveryRequest.setRecoveryCode(recoveryCode);
                    recoveryRequest.setPuk(recoveryPuk);
                    recoveryRequest.setGenerateRecoveryCodes(shouldGenerateRecoveryCodes);
                    recoveryRequest.setApplicationKey(applicationKey);
                    recoveryRequest.setMaxFailureCount(maxFailedCount);
                    recoveryRequest.setEphemeralPublicKey(ephemeralPublicKey);
                    recoveryRequest.setEncryptedData(encryptedData);
                    recoveryRequest.setMac(mac);
                    recoveryRequest.setNonce(nonce);
                    RecoveryCodeActivationResponse recoveryResponse = this.powerAuthClient.createActivationUsingRecoveryCode(recoveryRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                    Map processedCustomAttributes = customAttributes;
                    if (this.activationProvider != null && (activationFlags = this.activationProvider.getActivationFlags(identity, processedCustomAttributes = this.activationProvider.processCustomActivationAttributes(customAttributes, recoveryResponse.getActivationId(), recoveryResponse.getUserId(), recoveryResponse.getApplicationId(), ActivationType.RECOVERY, context), recoveryResponse.getActivationId(), recoveryResponse.getUserId(), recoveryResponse.getApplicationId(), ActivationType.RECOVERY, context)) != null && !activationFlags.isEmpty()) {
                        AddActivationFlagsRequest flagsRequest = new AddActivationFlagsRequest();
                        flagsRequest.setActivationId(recoveryResponse.getActivationId());
                        flagsRequest.getActivationFlags().addAll(activationFlags);
                        this.powerAuthClient.addActivationFlags(flagsRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                    }
                    if (this.activationProvider == null || this.activationProvider.shouldAutoCommitActivation(identity, customAttributes, recoveryResponse.getActivationId(), recoveryResponse.getUserId(), recoveryResponse.getApplicationId(), ActivationType.RECOVERY, context)) {
                        CommitActivationRequest commitRequest = new CommitActivationRequest();
                        commitRequest.setActivationId(recoveryResponse.getActivationId());
                        commitRequest.setExternalUserId(null);
                        CommitActivationResponse commitResponse = this.powerAuthClient.commitActivation(commitRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                        if (this.activationProvider != null && commitResponse.isActivated()) {
                            this.activationProvider.activationWasCommitted(identity, customAttributes, recoveryResponse.getActivationId(), recoveryResponse.getUserId(), recoveryResponse.getApplicationId(), ActivationType.RECOVERY, context);
                        }
                    }
                    return this.prepareEncryptedResponse(recoveryResponse.getEncryptedData(), recoveryResponse.getMac(), processedCustomAttributes);
                }
            }
            logger.warn("Invalid activation request");
            throw new PowerAuthInvalidRequestException();
        }
        catch (PowerAuthClientException ex) {
            if (ex.getPowerAuthError() instanceof PowerAuthErrorRecovery) {
                PowerAuthErrorRecovery errorRecovery = (PowerAuthErrorRecovery)ex.getPowerAuthError();
                logger.debug("Invalid recovery code, current PUK index: {}", (Object)errorRecovery.getCurrentRecoveryPukIndex());
                throw new PowerAuthRecoveryException(ex.getMessage(), "INVALID_RECOVERY_CODE", Integer.valueOf(errorRecovery.getCurrentRecoveryPukIndex()));
            }
            logger.warn("Creating PowerAuth activation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthActivationException();
        }
        catch (PowerAuthActivationException ex) {
            logger.warn("Creating PowerAuth activation failed, error: {}", (Object)ex.getMessage());
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth activation failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationStatusResponse getActivationStatus(ActivationStatusRequest request) throws PowerAuthActivationException {
        try {
            String activationId = request.getActivationId();
            String challenge = request.getChallenge();
            GetActivationStatusRequest statusRequest = new GetActivationStatusRequest();
            statusRequest.setActivationId(activationId);
            statusRequest.setChallenge(challenge);
            GetActivationStatusResponse paResponse = this.powerAuthClient.getActivationStatus(statusRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            ActivationStatusResponse response = new ActivationStatusResponse();
            response.setActivationId(paResponse.getActivationId());
            response.setEncryptedStatusBlob(paResponse.getEncryptedStatusBlob());
            response.setNonce(paResponse.getEncryptedStatusBlobNonce());
            if (this.applicationConfiguration != null) {
                ActivationContext activationContext = this.activationContextConverter.fromActivationDetailResponse(paResponse);
                response.setCustomObject(this.applicationConfiguration.statusServiceCustomObject(activationContext));
            }
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation status check failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    public ActivationRemoveResponse removeActivation(PowerAuthApiAuthentication apiAuthentication) throws PowerAuthActivationException {
        try {
            RemoveActivationResponse paResponse;
            String activationId = apiAuthentication.getActivationContext().getActivationId();
            String userId = apiAuthentication.getUserId();
            String applicationId = apiAuthentication.getApplicationId();
            RemoveActivationRequest removeRequest = new RemoveActivationRequest();
            removeRequest.setActivationId(activationId);
            removeRequest.setExternalUserId(null);
            if (this.activationProvider != null) {
                boolean revokeCodes = this.activationProvider.shouldRevokeRecoveryCodeOnRemove(activationId, userId, applicationId);
                removeRequest.setRevokeRecoveryCodes(Boolean.valueOf(revokeCodes));
                paResponse = this.powerAuthClient.removeActivation(removeRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
                this.activationProvider.activationWasRemoved(activationId, userId, applicationId);
            } else {
                removeRequest.setRevokeRecoveryCodes(Boolean.valueOf(false));
                paResponse = this.powerAuthClient.removeActivation(removeRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            }
            ActivationRemoveResponse response = new ActivationRemoveResponse();
            response.setActivationId(paResponse.getActivationId());
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth activation removal failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthActivationException();
        }
    }

    private ActivationLayer1Response prepareEncryptedResponse(String encryptedData, String mac, Map<String, Object> processedCustomAttributes) {
        EciesEncryptedResponse encryptedResponseL2 = new EciesEncryptedResponse();
        encryptedResponseL2.setEncryptedData(encryptedData);
        encryptedResponseL2.setMac(mac);
        ActivationLayer1Response responseL1 = new ActivationLayer1Response();
        responseL1.setCustomAttributes(processedCustomAttributes);
        responseL1.setActivationData(encryptedResponseL2);
        return responseL1;
    }
}

