/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.v3.CreateTokenRequest;
import com.wultra.security.powerauth.client.v3.CreateTokenResponse;
import com.wultra.security.powerauth.client.v3.RemoveTokenRequest;
import com.wultra.security.powerauth.client.v3.SignatureType;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.request.v3.TokenRemoveRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.model.response.v3.TokenRemoveResponse;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.spring.converter.v3.SignatureTypeConverter;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthSignatureTypeInvalidException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthTokenErrorException;
import io.getlime.security.powerauth.rest.api.spring.service.HttpCustomizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="tokenServiceV3")
public class TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private final PowerAuthClient powerAuthClient;
    private final HttpCustomizationService httpCustomizationService;

    @Autowired
    public TokenService(PowerAuthClient powerAuthClient, HttpCustomizationService httpCustomizationService) {
        this.powerAuthClient = powerAuthClient;
        this.httpCustomizationService = httpCustomizationService;
    }

    public EciesEncryptedResponse createToken(EciesEncryptedRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            PowerAuthSignatureTypes signatureFactors = authentication.getAuthenticationContext().getSignatureType();
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            String nonce = request.getNonce();
            SignatureTypeConverter converter = new SignatureTypeConverter();
            SignatureType signatureType = converter.convertFrom(signatureFactors);
            if (signatureType == null) {
                logger.warn("Invalid signature type: {}", (Object)signatureFactors);
                throw new PowerAuthSignatureTypeInvalidException();
            }
            String activationId = authentication.getActivationContext().getActivationId();
            PowerAuthSignatureHttpHeader httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader();
            String applicationKey = httpHeader.getApplicationKey();
            CreateTokenRequest tokenRequest = new CreateTokenRequest();
            tokenRequest.setActivationId(activationId);
            tokenRequest.setApplicationKey(applicationKey);
            tokenRequest.setEphemeralPublicKey(ephemeralPublicKey);
            tokenRequest.setEncryptedData(encryptedData);
            tokenRequest.setMac(mac);
            tokenRequest.setNonce(nonce);
            tokenRequest.setSignatureType(signatureType);
            CreateTokenResponse token = this.powerAuthClient.createToken(tokenRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            EciesEncryptedResponse response = new EciesEncryptedResponse();
            response.setMac(token.getMac());
            response.setEncryptedData(token.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("Creating PowerAuth token failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthTokenErrorException();
        }
    }

    public TokenRemoveResponse removeToken(TokenRemoveRequest request, PowerAuthApiAuthentication authentication) throws PowerAuthAuthenticationException {
        try {
            String activationId = authentication.getActivationContext().getActivationId();
            String tokenId = request.getTokenId();
            RemoveTokenRequest removeRequest = new RemoveTokenRequest();
            removeRequest.setActivationId(activationId);
            removeRequest.setTokenId(tokenId);
            this.powerAuthClient.removeToken(removeRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            TokenRemoveResponse response = new TokenRemoveResponse();
            response.setTokenId(tokenId);
            return response;
        }
        catch (Exception ex) {
            logger.warn("Removing PowerAuth token failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthTokenErrorException();
        }
    }
}

