/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.rest.api.spring.service.v3;

import com.wultra.security.powerauth.client.PowerAuthClient;
import com.wultra.security.powerauth.client.v3.CommitUpgradeRequest;
import com.wultra.security.powerauth.client.v3.CommitUpgradeResponse;
import com.wultra.security.powerauth.client.v3.StartUpgradeRequest;
import com.wultra.security.powerauth.client.v3.StartUpgradeResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.crypto.lib.enums.PowerAuthSignatureTypes;
import io.getlime.security.powerauth.http.PowerAuthEncryptionHttpHeader;
import io.getlime.security.powerauth.http.PowerAuthSignatureHttpHeader;
import io.getlime.security.powerauth.rest.api.model.request.v3.EciesEncryptedRequest;
import io.getlime.security.powerauth.rest.api.model.response.v3.EciesEncryptedResponse;
import io.getlime.security.powerauth.rest.api.spring.authentication.PowerAuthApiAuthentication;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.rest.api.spring.exception.PowerAuthUpgradeException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthInvalidRequestException;
import io.getlime.security.powerauth.rest.api.spring.exception.authentication.PowerAuthSignatureInvalidException;
import io.getlime.security.powerauth.rest.api.spring.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.rest.api.spring.service.HttpCustomizationService;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="upgradeServiceV3")
public class UpgradeService {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeService.class);
    private final PowerAuthClient powerAuthClient;
    private final PowerAuthAuthenticationProvider authenticationProvider;
    private final HttpCustomizationService httpCustomizationService;

    @Autowired
    public UpgradeService(PowerAuthClient powerAuthClient, PowerAuthAuthenticationProvider authenticationProvider, HttpCustomizationService httpCustomizationService) {
        this.powerAuthClient = powerAuthClient;
        this.authenticationProvider = authenticationProvider;
        this.httpCustomizationService = httpCustomizationService;
    }

    public EciesEncryptedResponse upgradeStart(EciesEncryptedRequest request, PowerAuthEncryptionHttpHeader header) throws PowerAuthUpgradeException {
        try {
            String ephemeralPublicKey = request.getEphemeralPublicKey();
            String encryptedData = request.getEncryptedData();
            String mac = request.getMac();
            String nonce = request.getNonce();
            String activationId = header.getActivationId();
            String applicationKey = header.getApplicationKey();
            StartUpgradeRequest upgradeRequest = new StartUpgradeRequest();
            upgradeRequest.setActivationId(activationId);
            upgradeRequest.setApplicationKey(applicationKey);
            upgradeRequest.setEphemeralPublicKey(ephemeralPublicKey);
            upgradeRequest.setEncryptedData(encryptedData);
            upgradeRequest.setMac(mac);
            upgradeRequest.setNonce(nonce);
            StartUpgradeResponse upgradeResponse = this.powerAuthClient.startUpgrade(upgradeRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            EciesEncryptedResponse response = new EciesEncryptedResponse();
            response.setMac(upgradeResponse.getMac());
            response.setEncryptedData(upgradeResponse.getEncryptedData());
            return response;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth upgrade start failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthUpgradeException();
        }
    }

    public Response upgradeCommit(String signatureHeader, HttpServletRequest httpServletRequest) throws PowerAuthAuthenticationException, PowerAuthUpgradeException {
        try {
            byte[] requestBodyBytes = this.authenticationProvider.extractRequestBodyBytes(httpServletRequest);
            if (requestBodyBytes == null || requestBodyBytes.length == 0) {
                logger.warn("Empty request body");
                throw new PowerAuthInvalidRequestException();
            }
            List<PowerAuthSignatureTypes> allowedSignatureTypes = Collections.singletonList(PowerAuthSignatureTypes.POSSESSION);
            PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignatureWithActivationDetails("POST", requestBodyBytes, "/pa/upgrade/commit", signatureHeader, allowedSignatureTypes, Integer.valueOf(3));
            if (!authentication.getAuthenticationContext().isValid() || authentication.getActivationContext().getActivationId() == null) {
                logger.debug("Signature validation failed");
                throw new PowerAuthSignatureInvalidException();
            }
            String activationId = authentication.getActivationContext().getActivationId();
            PowerAuthSignatureHttpHeader httpHeader = (PowerAuthSignatureHttpHeader)authentication.getHttpHeader();
            String applicationKey = httpHeader.getApplicationKey();
            CommitUpgradeRequest commitRequest = new CommitUpgradeRequest();
            commitRequest.setActivationId(activationId);
            commitRequest.setApplicationKey(applicationKey);
            CommitUpgradeResponse upgradeResponse = this.powerAuthClient.commitUpgrade(commitRequest, this.httpCustomizationService.getQueryParams(), this.httpCustomizationService.getHttpHeaders());
            if (upgradeResponse.isCommitted()) {
                return new Response();
            }
            logger.debug("Upgrade commit failed");
            throw new PowerAuthUpgradeException();
        }
        catch (PowerAuthAuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.warn("PowerAuth upgrade commit failed, error: {}", (Object)ex.getMessage());
            logger.debug(ex.getMessage(), (Throwable)ex);
            throw new PowerAuthUpgradeException();
        }
    }
}

