/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.annotation;

import io.getlime.rest.api.security.annotation.PowerAuth;
import io.getlime.rest.api.security.authentication.PowerAuthApiAuthentication;
import io.getlime.rest.api.security.exception.PowerAuthAuthenticationException;
import io.getlime.rest.api.security.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.powerauth.lib.enums.PowerAuthSignatureTypes;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class PowerAuthInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private PowerAuthAuthenticationProvider authenticationProvider;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        PowerAuth powerAuthAnnotation = (PowerAuth)handlerMethod.getMethodAnnotation(PowerAuth.class);
        if (powerAuthAnnotation != null) {
            PowerAuthApiAuthentication authentication = this.authenticationProvider.validateRequestSignature(request, powerAuthAnnotation.resourceId(), request.getHeader("X-PowerAuth-Authorization"), new ArrayList<PowerAuthSignatureTypes>(Arrays.asList(powerAuthAnnotation.signatureType())));
            if (authentication == null) {
                throw new PowerAuthAuthenticationException();
            }
            request.setAttribute("X-PowerAuth-Authentication-Object", (Object)authentication);
        }
        return super.preHandle(request, response, handler);
    }
}

