/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.controller;

import io.getlime.powerauth.soap.GetActivationStatusResponse;
import io.getlime.powerauth.soap.PrepareActivationResponse;
import io.getlime.powerauth.soap.RemoveActivationResponse;
import io.getlime.rest.api.model.ActivationCreateRequest;
import io.getlime.rest.api.model.ActivationCreateResponse;
import io.getlime.rest.api.model.ActivationRemoveRequest;
import io.getlime.rest.api.model.ActivationRemoveResponse;
import io.getlime.rest.api.model.ActivationStatusRequest;
import io.getlime.rest.api.model.ActivationStatusResponse;
import io.getlime.rest.api.model.PowerAuthAPIRequest;
import io.getlime.rest.api.model.PowerAuthAPIResponse;
import io.getlime.rest.api.security.application.PowerAuthApplicationConfiguration;
import io.getlime.rest.api.security.authentication.PowerAuthApiAuthentication;
import io.getlime.rest.api.security.exception.PowerAuthAuthenticationException;
import io.getlime.rest.api.security.provider.PowerAuthAuthenticationProvider;
import io.getlime.security.soap.client.PowerAuthServiceClient;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pa/activation"})
public class ActivationController {
    @Autowired
    private PowerAuthServiceClient powerAuthClient;
    @Autowired
    private PowerAuthAuthenticationProvider authenticationProvider;
    @Autowired(required=false)
    private PowerAuthApplicationConfiguration applicationConfiguration;

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @ResponseBody
    public PowerAuthAPIResponse<ActivationCreateResponse> createActivation(@RequestBody PowerAuthAPIRequest<ActivationCreateRequest> request) {
        String activationIDShort = ((ActivationCreateRequest)request.getRequestObject()).getActivationIdShort();
        String activationNonce = ((ActivationCreateRequest)request.getRequestObject()).getActivationNonce();
        String cDevicePublicKey = ((ActivationCreateRequest)request.getRequestObject()).getEncryptedDevicePublicKey();
        String activationName = ((ActivationCreateRequest)request.getRequestObject()).getActivationName();
        String extras = ((ActivationCreateRequest)request.getRequestObject()).getExtras();
        String applicationKey = ((ActivationCreateRequest)request.getRequestObject()).getApplicationKey();
        String applicationSignature = ((ActivationCreateRequest)request.getRequestObject()).getApplicationSignature();
        String clientEphemeralKey = ((ActivationCreateRequest)request.getRequestObject()).getEphemeralPublicKey();
        PrepareActivationResponse soapResponse = this.powerAuthClient.prepareActivation(activationIDShort, activationName, activationNonce, clientEphemeralKey, cDevicePublicKey, extras, applicationKey, applicationSignature);
        ActivationCreateResponse response = new ActivationCreateResponse();
        response.setActivationId(soapResponse.getActivationId());
        response.setActivationNonce(soapResponse.getActivationNonce());
        response.setEncryptedServerPublicKey(soapResponse.getEncryptedServerPublicKey());
        response.setEncryptedServerPublicKeySignature(soapResponse.getEncryptedServerPublicKeySignature());
        response.setEphemeralPublicKey(soapResponse.getEphemeralPublicKey());
        return new PowerAuthAPIResponse("OK", (Object)response);
    }

    @RequestMapping(value={"status"}, method={RequestMethod.POST})
    @ResponseBody
    public PowerAuthAPIResponse<ActivationStatusResponse> getActivationStatus(@RequestBody PowerAuthAPIRequest<ActivationStatusRequest> request) {
        String activationId = ((ActivationStatusRequest)request.getRequestObject()).getActivationId();
        GetActivationStatusResponse soapResponse = this.powerAuthClient.getActivationStatus(activationId);
        ActivationStatusResponse response = new ActivationStatusResponse();
        response.setActivationId(soapResponse.getActivationId());
        response.setEncryptedStatusBlob(soapResponse.getEncryptedStatusBlob());
        if (this.applicationConfiguration != null) {
            response.setCustomObject(this.applicationConfiguration.statusServiceCustomObject());
        }
        return new PowerAuthAPIResponse("OK", (Object)response);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST})
    @ResponseBody
    public PowerAuthAPIResponse<ActivationRemoveResponse> removeActivation(@RequestBody PowerAuthAPIRequest<ActivationRemoveRequest> request, @RequestHeader(value="X-PowerAuth-Authorization", required=true) String signatureHeader, HttpServletRequest servletRequest) throws Exception {
        PowerAuthApiAuthentication apiAuthentication = this.authenticationProvider.validateRequestSignature("POST", null, "/pa/activation/remove", signatureHeader);
        if (apiAuthentication != null && apiAuthentication.getActivationId() != null) {
            RemoveActivationResponse soapResponse = this.powerAuthClient.removeActivation(apiAuthentication.getActivationId());
            ActivationRemoveResponse response = new ActivationRemoveResponse();
            response.setActivationId(soapResponse.getActivationId());
            return new PowerAuthAPIResponse("OK", (Object)response);
        }
        throw new PowerAuthAuthenticationException("NOT AUTHORIZED");
    }
}

