/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.controller;

import com.google.common.io.BaseEncoding;
import io.getlime.rest.api.model.base.PowerAuthApiResponse;
import io.getlime.rest.api.model.response.VaultUnlockResponse;
import io.getlime.rest.api.security.exception.PowerAuthAuthenticationException;
import io.getlime.security.powerauth.lib.util.http.PowerAuthHttpBody;
import io.getlime.security.powerauth.lib.util.http.PowerAuthHttpHeader;
import io.getlime.security.soap.client.PowerAuthServiceClient;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pa/vault"})
public class SecureVaultController {
    @Autowired
    private PowerAuthServiceClient powerAuthClient;

    @RequestMapping(value={"unlock"}, method={RequestMethod.POST})
    @ResponseBody
    public PowerAuthApiResponse<VaultUnlockResponse> unlockVault(@RequestHeader(value="X-PowerAuth-Authorization", required=true, defaultValue="unknown") String signatureHeader) throws PowerAuthAuthenticationException, UnsupportedEncodingException {
        Map map = PowerAuthHttpHeader.parsePowerAuthSignatureHTTPHeader((String)signatureHeader);
        String activationId = (String)map.get("pa_activation_id");
        String applicationId = (String)map.get("pa_application_key");
        String signature = (String)map.get("pa_signature");
        String signatureType = (String)map.get("pa_signature_type");
        String nonce = (String)map.get("pa_nonce");
        String data = PowerAuthHttpBody.getSignatureBaseString((String)"POST", (String)"/pa/vault/unlock", (byte[])BaseEncoding.base64().decode((CharSequence)nonce), null);
        io.getlime.powerauth.soap.VaultUnlockResponse soapResponse = this.powerAuthClient.unlockVault(activationId, applicationId, data, signature, signatureType);
        if (!soapResponse.isSignatureValid()) {
            throw new PowerAuthAuthenticationException("USER_NOT_AUTHENTICATED");
        }
        VaultUnlockResponse response = new VaultUnlockResponse();
        response.setActivationId(soapResponse.getActivationId());
        response.setEncryptedVaultEncryptionKey(soapResponse.getEncryptedVaultEncryptionKey());
        return new PowerAuthApiResponse("OK", (Object)response);
    }
}

