/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.rest.api.security.filter;

import com.google.common.io.BaseEncoding;
import io.getlime.rest.api.security.filter.ResettableStreamHttpServletRequest;
import io.getlime.security.powerauth.lib.util.http.PowerAuthRequestCanonizationUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class PowerAuthRequestFilter
extends OncePerRequestFilter {
    public static final String POWERAUTH_SIGNATURE_BASE_STRING = "X-PowerAuth-Request-Body";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ResettableStreamHttpServletRequest resetableRequest = new ResettableStreamHttpServletRequest(request);
        if (request.getMethod().equals(HttpMethod.GET)) {
            String queryString = request.getQueryString();
            String signatureBaseStringData = PowerAuthRequestCanonizationUtils.canonizeGetParameters((String)queryString);
            if (signatureBaseStringData != null) {
                resetableRequest.setAttribute(POWERAUTH_SIGNATURE_BASE_STRING, BaseEncoding.base64().encode(signatureBaseStringData.getBytes("UTF-8")));
            }
        } else {
            byte[] body = resetableRequest.getRequestBody();
            if (body != null) {
                resetableRequest.setAttribute(POWERAUTH_SIGNATURE_BASE_STRING, BaseEncoding.base64().encode(body));
            }
        }
        super.doFilter((ServletRequest)resetableRequest, (ServletResponse)response, filterChain);
    }
}

