/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.tpp.engine.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.app.tppengine.model.entity.TppEngineError;
import io.getlime.security.powerauth.app.tppengine.model.request.CreateTppAppRequest;
import io.getlime.security.powerauth.app.tppengine.model.request.GiveConsentRequest;
import io.getlime.security.powerauth.app.tppengine.model.request.RemoveConsentRequest;
import io.getlime.security.powerauth.app.tppengine.model.response.ConsentDetailResponse;
import io.getlime.security.powerauth.app.tppengine.model.response.GiveConsentResponse;
import io.getlime.security.powerauth.app.tppengine.model.response.TppAppDetailResponse;
import io.getlime.security.powerauth.app.tppengine.model.response.UserConsentDetailResponse;
import io.getlime.security.powerauth.lib.tpp.engine.client.TppEngineClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public class TppEngineClient {
    private final String serviceUrl;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate;

    public TppEngineClient(String serviceUrl) {
        this(serviceUrl, null);
    }

    public TppEngineClient(String serviceUrl, ObjectMapper objectMapper) {
        this.serviceUrl = serviceUrl;
        this.objectMapper = objectMapper != null ? objectMapper : this.objectMapper();
        this.restTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter(this.objectMapper);
        ArrayList<MappingJackson2HttpMessageConverter> converters = new ArrayList<MappingJackson2HttpMessageConverter>();
        converters.add(converter);
        this.restTemplate.setMessageConverters(converters);
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
    }

    private ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ObjectResponse<ConsentDetailResponse> consentDetail(String id) throws TppEngineClientException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", id);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/consent?id={id}", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<ConsentDetailResponse>>(){}, params);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<UserConsentDetailResponse> consentStatus(String userId, String consentId, String clientId) throws TppEngineClientException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("userId", userId);
            params.put("consentId", consentId);
            params.put("clientId", clientId);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/user/consent/status?userId={userId}&consentId={consentId}&clientId={clientId}", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<UserConsentDetailResponse>>(){}, params);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<GiveConsentResponse> giveConsent(GiveConsentRequest request) throws TppEngineClientException {
        try {
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/user/consent", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<GiveConsentResponse>>(){}, new Object[0]);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public Response rejectConsent(RemoveConsentRequest request) throws TppEngineClientException {
        try {
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/user/consent", HttpMethod.DELETE, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<Response>(){}, new Object[0]);
            return (Response)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<TppAppDetailResponse> fetchAppInfo(String clientId) throws TppEngineClientException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("clientId", clientId);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/tpp/app?clientId={clientId}", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<TppAppDetailResponse>>(){}, params);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<TppAppDetailResponse> fetchAppInfoWithLicenseRestriction(String clientId, String tppLicense) throws TppEngineClientException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("clientId", clientId);
            params.put("tppLicense", tppLicense);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/tpp/app?clientId={clientId}&tppLicense={tppLicense}", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<TppAppDetailResponse>>(){}, params);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<List<TppAppDetailResponse>> fetchApplicationList(String tppLicense) throws TppEngineClientException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tppLicense", tppLicense);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/tpp/app/list?tppLicense={tppLicense}", HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<List<TppAppDetailResponse>>>(){}, params);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<TppAppDetailResponse> createApplication(CreateTppAppRequest request) throws TppEngineClientException {
        try {
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/tpp/app", HttpMethod.POST, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<TppAppDetailResponse>>(){}, new Object[0]);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<TppAppDetailResponse> updateApplication(String clientId, CreateTppAppRequest request) throws TppEngineClientException {
        try {
            HttpEntity entity = new HttpEntity((Object)new ObjectRequest((Object)request));
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("clientId", clientId);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/tpp/app?clientId={clientId}", HttpMethod.PUT, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<TppAppDetailResponse>>(){}, params);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public ObjectResponse<TppAppDetailResponse> renewClientSecret(String clientId, String tppLicense) throws TppEngineClientException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("clientId", clientId);
            params.put("tppLicense", tppLicense);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/tpp/app/renewSecret?clientId={clientId}&tppLicense={tppLicense}", HttpMethod.POST, null, (ParameterizedTypeReference)new ParameterizedTypeReference<ObjectResponse<TppAppDetailResponse>>(){}, params);
            return (ObjectResponse)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    public Response deleteApplication(String clientId, String tppLicense) throws TppEngineClientException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("clientId", clientId);
            params.put("tppLicense", tppLicense);
            ResponseEntity response = this.restTemplate.exchange(this.serviceUrl + "/tpp/app?clientId={clientId}&tppLicense={tppLicense}", HttpMethod.DELETE, null, (ParameterizedTypeReference)new ParameterizedTypeReference<Response>(){}, params);
            return (Response)response.getBody();
        }
        catch (HttpStatusCodeException ex) {
            throw this.httpStatusException(ex);
        }
        catch (ResourceAccessException ex) {
            throw this.resourceAccessException(ex);
        }
    }

    private TppEngineClientException resourceAccessException(ResourceAccessException ex) {
        TppEngineError error = new TppEngineError("COMMUNICATION_ERROR", ex.getMessage());
        return new TppEngineClientException(ex, error);
    }

    private TppEngineClientException httpStatusException(HttpStatusCodeException ex) {
        try {
            TypeReference<ObjectResponse<TppEngineError>> typeReference = new TypeReference<ObjectResponse<TppEngineError>>(){};
            ObjectResponse errorResponse = (ObjectResponse)this.objectMapper.readValue(ex.getResponseBodyAsString(), (TypeReference)typeReference);
            if (errorResponse == null) {
                TppEngineError error = new TppEngineError("ERROR_GENERIC", "IO error occurred: " + ex.getMessage());
                return new TppEngineClientException(ex, error);
            }
            TppEngineError error = (TppEngineError)errorResponse.getResponseObject();
            if (error == null) {
                error = new TppEngineError();
            }
            if (error.getCode() == null) {
                error.setCode("ERROR_GENERIC");
                error.setMessage(ex.getMessage());
            }
            return new TppEngineClientException(ex, error);
        }
        catch (IOException ex2) {
            if (ex.getStatusCode() != HttpStatus.OK) {
                TppEngineError error = new TppEngineError("COMMUNICATION_ERROR", "HTTP error occurred: " + ex.getMessage());
                return new TppEngineClientException(ex, error);
            }
            TppEngineError error = new TppEngineError("ERROR_GENERIC", "IO error occurred: " + ex2.getMessage());
            return new TppEngineClientException(ex2, error);
        }
    }
}

