/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.lib.tpp.engine.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.wultra.core.rest.client.base.DefaultRestClient;
import com.wultra.core.rest.client.base.RestClient;
import com.wultra.core.rest.client.base.RestClientConfiguration;
import com.wultra.core.rest.client.base.RestClientException;
import io.getlime.core.rest.model.base.request.ObjectRequest;
import io.getlime.core.rest.model.base.response.ObjectResponse;
import io.getlime.core.rest.model.base.response.Response;
import io.getlime.security.powerauth.app.tppengine.model.entity.TppEngineError;
import io.getlime.security.powerauth.app.tppengine.model.request.CreateTppAppRequest;
import io.getlime.security.powerauth.app.tppengine.model.request.GiveConsentRequest;
import io.getlime.security.powerauth.app.tppengine.model.request.RemoveConsentRequest;
import io.getlime.security.powerauth.app.tppengine.model.response.ConsentDetailResponse;
import io.getlime.security.powerauth.app.tppengine.model.response.GiveConsentResponse;
import io.getlime.security.powerauth.app.tppengine.model.response.TppAppDetailResponse;
import io.getlime.security.powerauth.app.tppengine.model.response.UserConsentDetailResponse;
import io.getlime.security.powerauth.lib.tpp.engine.client.TppEngineClientException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class TppEngineClient {
    private static final Logger logger = LoggerFactory.getLogger(TppEngineClient.class);
    private final RestClient restClient;

    public TppEngineClient(String serviceUrl) throws TppEngineClientException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            RestClientConfiguration config = new RestClientConfiguration();
            config.setBaseUrl(serviceUrl);
            config.setObjectMapper(objectMapper);
            this.restClient = new DefaultRestClient(config);
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "Rest client initialization failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    public TppEngineClient(RestClientConfiguration restClientConfiguration) throws TppEngineClientException {
        try {
            this.restClient = new DefaultRestClient(restClientConfiguration);
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "Rest client initialization failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    public ObjectResponse<ConsentDetailResponse> consentDetail(String id) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"id", Collections.singletonList(id));
        return this.getObjectImpl("/consent", (MultiValueMap<String, String>)params, ConsentDetailResponse.class);
    }

    public ObjectResponse<UserConsentDetailResponse> consentStatus(String userId, String consentId, String clientId) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"userId", Collections.singletonList(userId));
        params.put((Object)"consentId", Collections.singletonList(consentId));
        params.put((Object)"clientId", Collections.singletonList(clientId));
        return this.getObjectImpl("/consent", (MultiValueMap<String, String>)params, UserConsentDetailResponse.class);
    }

    public ObjectResponse<GiveConsentResponse> giveConsent(GiveConsentRequest request) throws TppEngineClientException {
        return this.postObjectImpl("/user/consent", new ObjectRequest((Object)request), GiveConsentResponse.class);
    }

    public Response rejectConsent(RemoveConsentRequest request) throws TppEngineClientException {
        return this.postObjectImpl("/user/consent/delete", new ObjectRequest((Object)request));
    }

    public ObjectResponse<TppAppDetailResponse> fetchAppInfo(String clientId) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"clientId", Collections.singletonList(clientId));
        return this.getObjectImpl("/tpp/app", (MultiValueMap<String, String>)params, TppAppDetailResponse.class);
    }

    public ObjectResponse<TppAppDetailResponse> fetchAppInfoWithLicenseRestriction(String clientId, String tppLicense) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"clientId", Collections.singletonList(clientId));
        params.put((Object)"tppLicense", Collections.singletonList(tppLicense));
        return this.getObjectImpl("/tpp/app", (MultiValueMap<String, String>)params, TppAppDetailResponse.class);
    }

    public ObjectResponse<List<TppAppDetailResponse>> fetchApplicationList(String tppLicense) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"tppLicense", Collections.singletonList(tppLicense));
        return this.getImpl("/tpp/app/list", (MultiValueMap<String, String>)params, new ParameterizedTypeReference<ObjectResponse<List<TppAppDetailResponse>>>(){});
    }

    public ObjectResponse<TppAppDetailResponse> createApplication(CreateTppAppRequest request) throws TppEngineClientException {
        return this.postObjectImpl("/tpp/app", new ObjectRequest((Object)request), TppAppDetailResponse.class);
    }

    public ObjectResponse<TppAppDetailResponse> updateApplication(String clientId, CreateTppAppRequest request) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"clientId", Collections.singletonList(clientId));
        return this.putObjectImpl("/tpp/app", new ObjectRequest((Object)request), (MultiValueMap<String, String>)params, TppAppDetailResponse.class);
    }

    public ObjectResponse<TppAppDetailResponse> renewClientSecret(String clientId, String tppLicense) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"clientId", Collections.singletonList(clientId));
        params.put((Object)"tppLicense", Collections.singletonList(tppLicense));
        return this.putObjectImpl("/tpp/app/renewSecret", null, (MultiValueMap<String, String>)params, TppAppDetailResponse.class);
    }

    public Response deleteApplication(String clientId, String tppLicense) throws TppEngineClientException {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.put((Object)"clientId", Collections.singletonList(clientId));
        params.put((Object)"tppLicense", Collections.singletonList(tppLicense));
        return this.deleteObjectImpl("/tpp/app", (MultiValueMap<String, String>)params);
    }

    private <T> T getImpl(String path, MultiValueMap<String, String> queryParams, ParameterizedTypeReference<T> typeReference) throws TppEngineClientException {
        try {
            return (T)this.restClient.get(path, queryParams, null, typeReference).getBody();
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "HTTP GET request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private <T> ObjectResponse<T> getObjectImpl(String path, MultiValueMap<String, String> queryParams, Class<T> responseType) throws TppEngineClientException {
        try {
            return this.restClient.getObject(path, queryParams, null, responseType);
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "HTTP GET request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private Response postObjectImpl(String path, ObjectRequest<?> request) throws TppEngineClientException {
        try {
            return this.restClient.postObject(path, request);
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "HTTP POST request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private <T> ObjectResponse<T> postObjectImpl(String path, ObjectRequest<?> request, Class<T> responseType) throws TppEngineClientException {
        try {
            return this.restClient.postObject(path, request, responseType);
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "HTTP POST request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private <T> ObjectResponse<T> putObjectImpl(String path, ObjectRequest<?> request, MultiValueMap<String, String> queryParams, Class<T> responseType) throws TppEngineClientException {
        try {
            return this.restClient.putObject(path, request, queryParams, null, responseType);
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "HTTP PUT request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private Response deleteObjectImpl(String path, MultiValueMap<String, String> queryParams) throws TppEngineClientException {
        try {
            return this.restClient.deleteObject(path, queryParams, null);
        }
        catch (RestClientException ex) {
            TppEngineClientException ex2 = new TppEngineClientException(ex, new TppEngineError(this.resolveErrorCode(ex), "HTTP DELETE request failed."));
            this.logError(ex2);
            throw ex2;
        }
    }

    private void logError(TppEngineClientException ex) {
        TppEngineError error = ex.getError();
        if (error != null) {
            logger.warn("TPP Engine REST API call failed with error code: {}", (Object)error.getCode());
        } else {
            logger.warn(ex.getMessage(), (Throwable)ex);
        }
    }

    private String resolveErrorCode(RestClientException ex) {
        if (ex.getStatusCode() == null) {
            return "ERROR_GENERIC";
        }
        if (ex.getStatusCode().is4xxClientError()) {
            return "TPP_ENGINE_CLIENT_ERROR";
        }
        if (ex.getStatusCode().is5xxServerError()) {
            return "REMOTE_ERROR";
        }
        return "COMMUNICATION_ERROR";
    }
}

