/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.app.tppengine.model.certificate;

import io.getlime.security.powerauth.app.tppengine.model.certificate.CertInfo;
import io.getlime.security.powerauth.app.tppengine.model.certificate.ICertificateParser;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import sun.security.x509.AVA;
import sun.security.x509.X500Name;

public class ICACertificateParser
implements ICertificateParser {
    public static final String psd2 = "0.4.0.19495.2";
    public static final String psp_as = "0.4.0.19495.1.1";
    public static final String psp_pi = "0.4.0.19495.1.2";
    public static final String psp_ai = "0.4.0.19495.1.3";
    public static final String psp_ic = "0.4.0.19495.1.4";

    @Override
    public CertInfo parse(String certificatePem) throws CertificateException {
        if (certificatePem == null) {
            throw new CertificateException("Certificate in PEM format not found.");
        }
        if (certificatePem.startsWith("-----BEGIN%20CERTIFICATE-----")) {
            try {
                certificatePem = URLDecoder.decode(certificatePem, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new CertificateException("Unable to extract certificate in PEM format (nginx).");
            }
        }
        certificatePem = certificatePem.replaceAll(" ", "\n").replace("-----BEGIN\nCERTIFICATE-----", "-----BEGIN CERTIFICATE-----").replace("-----END\nCERTIFICATE-----", "-----END CERTIFICATE-----");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(certificatePem.getBytes(StandardCharsets.UTF_8));
        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
        try {
            byte[] qcStatement = cert.getExtensionValue("1.3.6.1.5.5.7.1.3");
            if (qcStatement == null) {
                throw new CertificateException("Unable to extract PSD2 mandates.");
            }
            ASN1Primitive qcStatementAsn1Primitive = JcaX509ExtensionUtils.parseExtensionValue((byte[])qcStatement);
            DLSequence it = (DLSequence)qcStatementAsn1Primitive;
            HashSet<CertInfo.PSD2> psd2Mandates = new HashSet<CertInfo.PSD2>();
            for (ASN1Encodable asn1Primitive : it) {
                DLSequence sequence;
                if (!(asn1Primitive instanceof DLSequence) || (sequence = (DLSequence)asn1Primitive).size() != 2) continue;
                ASN1ObjectIdentifier id = (ASN1ObjectIdentifier)sequence.getObjectAt(0);
                DLSequence mandates = (DLSequence)sequence.getObjectAt(1);
                if (!psd2.equals(id.getId())) continue;
                for (ASN1Encodable mandate : mandates) {
                    if (!(mandate instanceof DLSequence)) continue;
                    for (ASN1Encodable seq : (DLSequence)mandate) {
                        DLSequence a = (DLSequence)seq;
                        ASN1ObjectIdentifier identifier = (ASN1ObjectIdentifier)((DLSequence)seq).getObjectAt(0);
                        if (psp_as.equals(identifier.getId())) {
                            psd2Mandates.add(CertInfo.PSD2.PSP_AS);
                        }
                        if (psp_ai.equals(identifier.getId())) {
                            psd2Mandates.add(CertInfo.PSD2.PSP_AI);
                        }
                        if (psp_pi.equals(identifier.getId())) {
                            psd2Mandates.add(CertInfo.PSD2.PSP_PI);
                        }
                        if (!psp_ic.equals(identifier.getId())) continue;
                        psd2Mandates.add(CertInfo.PSD2.PSP_IC);
                    }
                }
            }
            List<AVA> avaList = ((X500Name)cert.getSubjectDN()).allAvas();
            String country = null;
            String serialNumber = null;
            String commonName = null;
            String psd2License = null;
            String organization = null;
            String street = null;
            String city = null;
            String zipCode = null;
            String region = null;
            String website = null;
            for (AVA ava : avaList) {
                String oid = ava.getObjectIdentifier().toString();
                String val = ava.getValueString();
                switch (oid) {
                    case "2.5.4.6": {
                        country = val;
                        break;
                    }
                    case "2.5.4.3": {
                        commonName = val;
                        website = "https://" + val;
                        break;
                    }
                    case "2.5.4.10": {
                        organization = val;
                        break;
                    }
                    case "2.5.4.9": {
                        street = val;
                        break;
                    }
                    case "2.5.4.7": {
                        city = val;
                        break;
                    }
                    case "2.5.4.17": {
                        zipCode = val;
                        break;
                    }
                    case "2.5.4.5": {
                        serialNumber = val;
                        break;
                    }
                    case "2.5.4.8": {
                        region = val;
                        break;
                    }
                    case "2.5.4.97": {
                        psd2License = val;
                    }
                }
            }
            return new CertInfo(serialNumber, commonName, psd2License, organization, street, city, zipCode, region, country, website, psd2Mandates);
        }
        catch (Throwable e) {
            throw new CertificateException("Unable to extract PSD2 mandates.");
        }
    }
}

