/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.app.tppengine.model.certificate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class CertInfo {
    public static final String HTTP_HEADER = "X-Client-Certificate";
    private String serialNumber;
    private String commonName;
    private String psd2License;
    private String organization;
    private String street;
    private String city;
    private String zipCode;
    private String region;
    private String country;
    private String website;
    private Set<PSD2> psd2Mandates;

    public CertInfo(String serialNumber, String commonName, String psd2License, String organization, String street, String city, String zipCode, String region, String country, String website, Set<PSD2> psd2Mandates) {
        this.serialNumber = serialNumber;
        this.commonName = commonName;
        this.psd2License = psd2License;
        this.organization = organization;
        this.street = street;
        this.city = city;
        this.zipCode = zipCode;
        this.region = region;
        this.country = country;
        this.website = website;
        this.psd2Mandates = new HashSet<PSD2>(psd2Mandates);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getPsd2License() {
        return this.psd2License;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getStreet() {
        return this.street;
    }

    public String getCity() {
        return this.city;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCountry() {
        return this.country;
    }

    public String getWebsite() {
        return this.website;
    }

    public Set<PSD2> getPsd2Mandates() {
        return this.psd2Mandates;
    }

    public boolean hasPsd2License() {
        return this.psd2License != null && !this.psd2License.isEmpty();
    }

    public String getAddressUnstructured() {
        ArrayList<String> addressComponents = new ArrayList<String>();
        if (this.street != null) {
            addressComponents.add(this.street);
        }
        if (this.city != null) {
            addressComponents.add(this.city);
        }
        if (this.zipCode != null) {
            addressComponents.add(this.zipCode);
        }
        if (this.region != null) {
            addressComponents.add(this.region);
        }
        if (this.country != null) {
            addressComponents.add(this.country);
        }
        return String.join((CharSequence)"\n", addressComponents);
    }

    public static enum PSD2 {
        PSP_AI,
        PSP_AS,
        PSP_IC,
        PSP_PI;

    }
}

