/*
 * Decompiled with CFR 0.152.
 */
package io.getlime.security.powerauth.app.tppengine.model.validator;

import io.getlime.security.powerauth.app.tppengine.model.request.CreateTppAppRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CreateTppAppRequestValidator {
    public static List<String> validate(CreateTppAppRequest source) {
        return CreateTppAppRequestValidator.validate(source, null);
    }

    public static List<String> validate(CreateTppAppRequest source, Set<String> permittedScopes) {
        String appType;
        String appName;
        String tppName;
        ArrayList<String> errors = new ArrayList<String>();
        String tppLicense = source.getTppLicense();
        if (tppLicense == null || tppLicense.isEmpty()) {
            errors.add("License information is not present.");
        }
        if ((tppName = source.getTppName()) == null || tppName.isEmpty()) {
            errors.add("Third-party name is not present.");
        }
        if ((appName = source.getAppName()) == null || appName.isEmpty()) {
            errors.add("Application name is not present.");
        }
        if ((appType = source.getAppType()) == null || appType.isEmpty()) {
            errors.add("Application type is not present.");
        } else if (!"web".equals(appType) && !"native".equals(appType)) {
            errors.add("Invalid application type - must be 'native' or 'web'.");
        }
        String[] redirectUris = source.getRedirectUris();
        if (redirectUris == null || redirectUris.length == 0) {
            errors.add("You must provide at least one redirect URI.");
        } else {
            for (String redirectUri : redirectUris) {
                try {
                    new URI(redirectUri);
                }
                catch (URISyntaxException e) {
                    errors.add("You provided an invalid redirect URI: " + redirectUri);
                }
            }
        }
        String[] scopes = source.getScopes();
        if (scopes == null || scopes.length == 0) {
            errors.add("You must provide at least one OAuth 2.0 scope.");
        } else {
            for (String scope : scopes) {
                if (!scope.matches("^[A-Za-z0-9]+$")) {
                    errors.add("You provided an invalid scope: " + scope);
                    continue;
                }
                if (permittedScopes == null || permittedScopes.contains(scope)) continue;
                errors.add("You provided an invalid scope: " + scope);
            }
        }
        return errors.isEmpty() ? null : errors;
    }
}

