/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.avatarview.stream.integration;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.Px;
import io.getstream.avatarview.coil.Avatar;
import io.getstream.avatarview.coil.AvatarBitmapFactory;
import io.getstream.avatarview.stream.integration.R;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\bH\u0002J$\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\fH\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0015\u001a\u00020\fH\u0002J+\u0010\u001a\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\u001c\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\fH\u0002J0\u0010\u001f\u001a\u00020\u001d*\u00020\u001e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0015\u001a\u00020\fH\u0002J+\u0010 \u001a\u0004\u0018\u0001H!\"\u0004\b\u0000\u0010!*\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lio/getstream/avatarview/stream/integration/StreamAvatarBitmapFactory;", "Lio/getstream/avatarview/coil/AvatarBitmapFactory;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "gradientBaseColors", "", "sp", "", "getSp", "(F)F", "adjustColorLBrightness", "", "color", "factor", "createInitialsBitmap", "Landroid/graphics/Bitmap;", "data", "", "avatar", "Lio/getstream/avatarview/coil/Avatar;", "avatarSize", "createLinearGradientShader", "Landroid/graphics/Shader;", "initials", "", "loadAvatarPlaceholderBitmap", "(Ljava/lang/Object;Lio/getstream/avatarview/coil/Avatar;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "drawGradient", "", "Landroid/graphics/Canvas;", "drawInitials", "getTagFromInitialsMap", "T", "key", "(Lio/getstream/avatarview/coil/Avatar;Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;", "Companion", "avatarview-stream-integration_release"})
public final class StreamAvatarBitmapFactory
extends AvatarBitmapFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final int[] gradientBaseColors;
    private static final float GRADIENT_DARKER_COLOR_FACTOR = 1.3f;
    private static final float GRADIENT_LIGHTER_COLOR_FACTOR = 0.7f;
    @NotNull
    public static final String BAG_AVATAR_INITIALS = "BAG_AVATAR_INITIALS";
    @NotNull
    public static final String BAG_AVATAR_INITIALS_FONT = "BAG_AVATAR_INITIALS_FONT";
    @NotNull
    public static final String BAG_AVATAR_INITIALS_TEXT_SIZE = "BAG_AVATAR_INITIALS_TEXT_SIZE";
    @NotNull
    public static final String BAG_AVATAR_INITIALS_TEXT_COLOR = "BAG_AVATAR_INITIALS_TEXT_COLOR";

    public StreamAvatarBitmapFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        int[] nArray = this.context.getResources().getIntArray(R.array.avatarView_gradient_colors);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"context.resources.getInt\u2026atarView_gradient_colors)");
        this.gradientBaseColors = nArray;
    }

    @Nullable
    public Object loadAvatarPlaceholderBitmap(@Nullable Object data, @NotNull Avatar avatar, int avatarSize, @NotNull Continuation<? super Bitmap> $completion) {
        return this.createInitialsBitmap(data, avatar, avatarSize);
    }

    private final Bitmap createInitialsBitmap(Object data, Avatar avatar, @Px int avatarSize) {
        Bitmap bitmap;
        String string = (String)this.getTagFromInitialsMap(avatar, data, BAG_AVATAR_INITIALS);
        if (string == null) {
            string = "";
        }
        String initials = string;
        Bitmap $this$createInitialsBitmap_u24lambda_u2d0 = bitmap = Bitmap.createBitmap((int)avatarSize, (int)avatarSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        boolean bl = false;
        Canvas canvas = new Canvas($this$createInitialsBitmap_u24lambda_u2d0);
        this.drawGradient(canvas, initials, avatarSize);
        this.drawInitials(canvas, data, avatar, initials, avatarSize);
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(avatarSize,\u2026ls, avatarSize)\n        }");
        return bitmap2;
    }

    private final void drawGradient(Canvas $this$drawGradient, String initials, int avatarSize) {
        Paint paint;
        Paint $this$drawGradient_u24lambda_u2d1 = paint = new Paint(1);
        boolean bl = false;
        $this$drawGradient_u24lambda_u2d1.setAntiAlias(true);
        $this$drawGradient_u24lambda_u2d1.setStyle(Paint.Style.FILL);
        $this$drawGradient_u24lambda_u2d1.setShader(this.createLinearGradientShader(initials, avatarSize));
        Paint paint2 = paint;
        $this$drawGradient.drawRect(0.0f, 0.0f, (float)avatarSize, (float)avatarSize, paint2);
    }

    private final void drawInitials(Canvas $this$drawInitials, Object data, Avatar avatar, String initials, @Px int avatarSize) {
        Paint paint;
        Paint $this$drawInitials_u24lambda_u2d2 = paint = new Paint(1);
        boolean bl = false;
        $this$drawInitials_u24lambda_u2d2.setStyle(Paint.Style.FILL);
        $this$drawInitials_u24lambda_u2d2.setTextAlign(Paint.Align.CENTER);
        Integer n = (Integer)this.getTagFromInitialsMap(avatar, data, BAG_AVATAR_INITIALS_TEXT_COLOR);
        $this$drawInitials_u24lambda_u2d2.setColor(n == null ? -1 : n);
        Float f = (Float)this.getTagFromInitialsMap(avatar, data, BAG_AVATAR_INITIALS_TEXT_SIZE);
        $this$drawInitials_u24lambda_u2d2.setTextSize(this.getSp(f == null ? 13.0f : f.floatValue()));
        Integer n2 = (Integer)this.getTagFromInitialsMap(avatar, data, BAG_AVATAR_INITIALS_FONT);
        $this$drawInitials_u24lambda_u2d2.setTypeface(Typeface.defaultFromStyle((int)(n2 == null ? 0 : n2)));
        Paint textPaint = paint;
        $this$drawInitials.drawText(initials, (float)avatarSize / 2.0f, (float)avatarSize / 2.0f - (textPaint.ascent() + textPaint.descent()) / 2.0f, textPaint);
    }

    private final float getSp(float $this$sp) {
        return TypedValue.applyDimension((int)2, (float)$this$sp, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
    }

    private final Shader createLinearGradientShader(String initials, @Px int avatarSize) {
        int baseColorIndex = Math.abs(initials.hashCode()) % this.gradientBaseColors.length;
        int baseColor = this.gradientBaseColors[baseColorIndex];
        return (Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)avatarSize, this.adjustColorLBrightness(baseColor, 1.3f), this.adjustColorLBrightness(baseColor, 0.7f), Shader.TileMode.CLAMP);
    }

    private final int adjustColorLBrightness(int color, float factor) {
        int a = Color.alpha((int)color);
        int r = MathKt.roundToInt((float)((float)Color.red((int)color) * factor));
        int g = MathKt.roundToInt((float)((float)Color.green((int)color) * factor));
        int b = MathKt.roundToInt((float)((float)Color.blue((int)color) * factor));
        return Color.argb((int)a, (int)RangesKt.coerceAtMost((int)r, (int)255), (int)RangesKt.coerceAtMost((int)g, (int)255), (int)RangesKt.coerceAtMost((int)b, (int)255));
    }

    private final <T> T getTagFromInitialsMap(Avatar $this$getTagFromInitialsMap, Object data, String key) {
        String string;
        Object object = data;
        if (object == null) {
            string = "";
        } else {
            string = object.toString();
            if (string == null) {
                string = "";
            }
        }
        Map map = (Map)$this$getTagFromInitialsMap.getTag(string);
        Map map2 = map == null ? (Map)new LinkedHashMap() : map;
        map = map2.get(key);
        if (map == null) {
            // empty if block
        }
        return (T)map;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/getstream/avatarview/stream/integration/StreamAvatarBitmapFactory$Companion;", "", "()V", "BAG_AVATAR_INITIALS", "", "BAG_AVATAR_INITIALS_FONT", "BAG_AVATAR_INITIALS_TEXT_COLOR", "BAG_AVATAR_INITIALS_TEXT_SIZE", "GRADIENT_DARKER_COLOR_FACTOR", "", "GRADIENT_LIGHTER_COLOR_FACTOR", "avatarview-stream-integration_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

