/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.avatarview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.Px;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.content.res.ResourcesCompat;
import io.getstream.avatarview.AvatarShape;
import io.getstream.avatarview.IndicatorPosition;
import io.getstream.avatarview.R;
import io.getstream.avatarview.internal.ExtensionsKt;
import io.getstream.avatarview.internal.InternalAvatarViewApi;
import io.getstream.avatarview.internal.PropertiesKt;
import io.getstream.avatarview.internal.ViewPropertyDelegate;
import io.getstream.avatarview.internal.ViewPropertyKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 \u0090\u00012\u00020\u00012\u00020\u0002:\u0002\u0090\u0001B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0002J\u0014\u0010\u0082\u0001\u001a\u00030\u0081\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u0014\u0010\u0085\u0001\u001a\u00030\u0081\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u0014\u0010\u0086\u0001\u001a\u00030\u0081\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u0014\u0010\u0087\u0001\u001a\u00030\u0081\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u001c\u0010\u0088\u0001\u001a\u00030\u0081\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\n\u0010\u0089\u0001\u001a\u00030\u0081\u0001H\u0014J\u0014\u0010\u008a\u0001\u001a\u00030\u0081\u00012\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0014J\u001c\u0010\u008b\u0001\u001a\u00030\u0081\u00012\u0007\u0010\u008c\u0001\u001a\u00020\b2\u0007\u0010\u008d\u0001\u001a\u00020\bH\u0014J\u0013\u0010\u008e\u0001\u001a\u00030\u0081\u00012\t\b\u0001\u0010\u008f\u0001\u001a\u00020\bR+\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR+\u0010\u0013\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00128G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R+\u0010\u0019\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0011\u001a\u0004\b\u001a\u0010\r\"\u0004\b\u001b\u0010\u000fR/\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010\n\u001a\u0004\u0018\u00010\u001d8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u0011\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R+\u0010$\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u0011\u001a\u0004\b%\u0010\r\"\u0004\b&\u0010\u000fR+\u0010(\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u0011\u001a\u0004\b)\u0010\r\"\u0004\b*\u0010\u000fR+\u0010,\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u0011\u001a\u0004\b-\u0010\r\"\u0004\b.\u0010\u000fR+\u00100\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u0010\u0011\u001a\u0004\b1\u0010\r\"\u0004\b2\u0010\u000fR+\u00104\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00128G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b7\u0010\u0011\u001a\u0004\b5\u0010\u0015\"\u0004\b6\u0010\u0017R+\u00109\u001a\u0002082\u0006\u0010\n\u001a\u0002088F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b>\u0010\u0011\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010B\u001a\u00020C8\u0016X\u0097\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\bD\u0010E\u001a\u0004\bF\u0010GR/\u0010I\u001a\u0004\u0018\u00010H2\b\u0010\n\u001a\u0004\u0018\u00010H8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bN\u0010\u0011\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR+\u0010O\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bR\u0010\u0011\u001a\u0004\bP\u0010\r\"\u0004\bQ\u0010\u000fR+\u0010S\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00128F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bV\u0010\u0011\u001a\u0004\bT\u0010\u0015\"\u0004\bU\u0010\u0017R+\u0010W\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b8G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bZ\u0010\u0011\u001a\u0004\bX\u0010\r\"\u0004\bY\u0010\u000fR/\u0010[\u001a\u0004\u0018\u00010H2\b\u0010\n\u001a\u0004\u0018\u00010H8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b^\u0010\u0011\u001a\u0004\b\\\u0010K\"\u0004\b]\u0010MR+\u0010`\u001a\u00020_2\u0006\u0010\n\u001a\u00020_8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\be\u0010\u0011\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u000e\u0010f\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010i\u001a\u00020h2\u0006\u0010\n\u001a\u00020h8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bn\u0010\u0011\u001a\u0004\bj\u0010k\"\u0004\bl\u0010mR+\u0010o\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00128F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\br\u0010\u0011\u001a\u0004\bp\u0010\u0015\"\u0004\bq\u0010\u0017R$\u0010t\u001a\u00020\b2\u0006\u0010s\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010\r\"\u0004\bv\u0010\u000fR/\u0010w\u001a\u0004\u0018\u00010H2\b\u0010\n\u001a\u0004\u0018\u00010H8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bz\u0010\u0011\u001a\u0004\bx\u0010K\"\u0004\by\u0010MR+\u0010{\u001a\u00020_2\u0006\u0010\n\u001a\u00020_8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b~\u0010\u0011\u001a\u0004\b|\u0010b\"\u0004\b}\u0010dR\u000e\u0010\u007f\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0091\u0001"}, d2={"Lio/getstream/avatarview/AvatarView;", "Landroidx/appcompat/widget/AppCompatImageView;", "Lkotlinx/coroutines/CoroutineScope;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "avatarBorderColor", "getAvatarBorderColor", "()I", "setAvatarBorderColor", "(I)V", "avatarBorderColor$delegate", "Lio/getstream/avatarview/internal/ViewPropertyDelegate;", "", "avatarBorderRadius", "getAvatarBorderRadius", "()F", "setAvatarBorderRadius", "(F)V", "avatarBorderRadius$delegate", "avatarBorderWidth", "getAvatarBorderWidth", "setAvatarBorderWidth", "avatarBorderWidth$delegate", "", "avatarInitials", "getAvatarInitials", "()Ljava/lang/String;", "setAvatarInitials", "(Ljava/lang/String;)V", "avatarInitials$delegate", "avatarInitialsBackgroundColor", "getAvatarInitialsBackgroundColor", "setAvatarInitialsBackgroundColor", "avatarInitialsBackgroundColor$delegate", "avatarInitialsStyle", "getAvatarInitialsStyle", "setAvatarInitialsStyle", "avatarInitialsStyle$delegate", "avatarInitialsTextColor", "getAvatarInitialsTextColor", "setAvatarInitialsTextColor", "avatarInitialsTextColor$delegate", "avatarInitialsTextSize", "getAvatarInitialsTextSize", "setAvatarInitialsTextSize", "avatarInitialsTextSize$delegate", "avatarInitialsTextSizeRatio", "getAvatarInitialsTextSizeRatio", "setAvatarInitialsTextSizeRatio", "avatarInitialsTextSizeRatio$delegate", "Lio/getstream/avatarview/AvatarShape;", "avatarShape", "getAvatarShape", "()Lio/getstream/avatarview/AvatarShape;", "setAvatarShape", "(Lio/getstream/avatarview/AvatarShape;)V", "avatarShape$delegate", "backgroundPaint", "Landroid/graphics/Paint;", "borderPaint", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext$annotations", "()V", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "Landroid/graphics/drawable/Drawable;", "errorPlaceholder", "getErrorPlaceholder", "()Landroid/graphics/drawable/Drawable;", "setErrorPlaceholder", "(Landroid/graphics/drawable/Drawable;)V", "errorPlaceholder$delegate", "indicatorBorderColor", "getIndicatorBorderColor", "setIndicatorBorderColor", "indicatorBorderColor$delegate", "indicatorBorderSizeCriteria", "getIndicatorBorderSizeCriteria", "setIndicatorBorderSizeCriteria", "indicatorBorderSizeCriteria$delegate", "indicatorColor", "getIndicatorColor", "setIndicatorColor", "indicatorColor$delegate", "indicatorDrawable", "getIndicatorDrawable", "setIndicatorDrawable", "indicatorDrawable$delegate", "", "indicatorEnabled", "getIndicatorEnabled", "()Z", "setIndicatorEnabled", "(Z)V", "indicatorEnabled$delegate", "indicatorOutlinePaint", "indicatorPaint", "Lio/getstream/avatarview/IndicatorPosition;", "indicatorPosition", "getIndicatorPosition", "()Lio/getstream/avatarview/IndicatorPosition;", "setIndicatorPosition", "(Lio/getstream/avatarview/IndicatorPosition;)V", "indicatorPosition$delegate", "indicatorSizeCriteria", "getIndicatorSizeCriteria", "setIndicatorSizeCriteria", "indicatorSizeCriteria$delegate", "value", "maxSectionSize", "getMaxSectionSize", "setMaxSectionSize", "placeholder", "getPlaceholder", "setPlaceholder", "placeholder$delegate", "supportRtlEnabled", "getSupportRtlEnabled", "setSupportRtlEnabled", "supportRtlEnabled$delegate", "textPaint", "applyPaintStyles", "", "drawBorder", "canvas", "Landroid/graphics/Canvas;", "drawColor", "drawIndicator", "drawInitials", "initAttributes", "onDetachedFromWindow", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setIndicatorRes", "drawableRes", "Companion", "avatarview_release"})
public final class AvatarView
extends AppCompatImageView
implements CoroutineScope {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Paint borderPaint;
    @NotNull
    private final Paint indicatorOutlinePaint;
    @NotNull
    private final Paint indicatorPaint;
    @NotNull
    private final Paint backgroundPaint;
    @NotNull
    private final Paint textPaint;
    @NotNull
    private final ViewPropertyDelegate avatarBorderWidth$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarBorderColor$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarBorderRadius$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarShape$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarInitials$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarInitialsTextSize$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarInitialsTextSizeRatio$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarInitialsTextColor$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarInitialsStyle$delegate;
    @NotNull
    private final ViewPropertyDelegate avatarInitialsBackgroundColor$delegate;
    @NotNull
    private final ViewPropertyDelegate indicatorEnabled$delegate;
    @NotNull
    private final ViewPropertyDelegate indicatorPosition$delegate;
    @NotNull
    private final ViewPropertyDelegate indicatorColor$delegate;
    @NotNull
    private final ViewPropertyDelegate indicatorBorderColor$delegate;
    @NotNull
    private final ViewPropertyDelegate indicatorSizeCriteria$delegate;
    @NotNull
    private final ViewPropertyDelegate indicatorBorderSizeCriteria$delegate;
    @NotNull
    private final ViewPropertyDelegate indicatorDrawable$delegate;
    @NotNull
    private final ViewPropertyDelegate supportRtlEnabled$delegate;
    @NotNull
    private final ViewPropertyDelegate placeholder$delegate;
    @NotNull
    private final ViewPropertyDelegate errorPlaceholder$delegate;
    private int maxSectionSize;
    @NotNull
    private final CoroutineContext coroutineContext;
    public static final int AVATAR_SIZE_EXTRA = 1;
    private static final float BORDER_OFFSET = 4.0f;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public AvatarView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void $this$textPaint_u24lambda_u2d4;
        Paint $this$backgroundPaint_u24lambda_u2d3;
        Paint $this$indicatorPaint_u24lambda_u2d2;
        Paint $this$indicatorOutlinePaint_u24lambda_u2d1;
        Paint $this$borderPaint_u24lambda_u2d0;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Paint paint2 = paint = new Paint(1);
        AvatarView avatarView = this;
        boolean bl = false;
        $this$borderPaint_u24lambda_u2d0.setStyle(Paint.Style.STROKE);
        avatarView.borderPaint = paint;
        $this$borderPaint_u24lambda_u2d0 = paint = new Paint();
        avatarView = this;
        boolean bl2 = false;
        $this$indicatorOutlinePaint_u24lambda_u2d1.setStyle(Paint.Style.FILL);
        avatarView.indicatorOutlinePaint = paint;
        $this$indicatorOutlinePaint_u24lambda_u2d1 = paint = new Paint();
        avatarView = this;
        boolean bl3 = false;
        $this$indicatorPaint_u24lambda_u2d2.setStyle(Paint.Style.FILL);
        avatarView.indicatorPaint = paint;
        $this$indicatorPaint_u24lambda_u2d2 = paint = new Paint();
        avatarView = this;
        boolean bl4 = false;
        $this$backgroundPaint_u24lambda_u2d3.setStyle(Paint.Style.FILL);
        avatarView.backgroundPaint = paint;
        $this$backgroundPaint_u24lambda_u2d3 = paint = new Paint();
        avatarView = this;
        boolean bl5 = false;
        $this$textPaint_u24lambda_u2d4.setTextAlign(Paint.Align.CENTER);
        $this$textPaint_u24lambda_u2d4.setStyle(Paint.Style.FILL);
        avatarView.textPaint = paint;
        int $this$dp$iv = 3;
        boolean $i$f$getDp = false;
        this.avatarBorderWidth$delegate = ViewPropertyKt.viewProperty((View)this, MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics())));
        this.avatarBorderColor$delegate = ViewPropertyKt.viewProperty((View)this, -1);
        $this$dp$iv = 6;
        $i$f$getDp = false;
        this.avatarBorderRadius$delegate = ViewPropertyKt.viewProperty((View)this, Float.valueOf(MathKt.roundToInt((float)TypedValue.applyDimension((int)1, (float)$this$dp$iv, (DisplayMetrics)Resources.getSystem().getDisplayMetrics()))));
        this.avatarShape$delegate = ViewPropertyKt.viewProperty((View)this, (Object)AvatarShape.CIRCLE);
        this.avatarInitials$delegate = ViewPropertyKt.viewProperty((View)this, null);
        this.avatarInitialsTextSize$delegate = ViewPropertyKt.viewProperty((View)this, -1);
        this.avatarInitialsTextSizeRatio$delegate = ViewPropertyKt.viewProperty((View)this, Float.valueOf(0.33f));
        this.avatarInitialsTextColor$delegate = ViewPropertyKt.viewProperty((View)this, -1);
        this.avatarInitialsStyle$delegate = ViewPropertyKt.viewProperty((View)this, 0);
        this.avatarInitialsBackgroundColor$delegate = ViewPropertyKt.viewProperty((View)this, PropertiesKt.getInternalBlue());
        this.indicatorEnabled$delegate = ViewPropertyKt.viewProperty((View)this, false);
        this.indicatorPosition$delegate = ViewPropertyKt.viewProperty((View)this, (Object)IndicatorPosition.TOP_RIGHT);
        this.indicatorColor$delegate = ViewPropertyKt.viewProperty((View)this, PropertiesKt.getInternalGreen());
        this.indicatorBorderColor$delegate = ViewPropertyKt.viewProperty((View)this, -1);
        this.indicatorSizeCriteria$delegate = ViewPropertyKt.viewProperty((View)this, Float.valueOf(8.0f));
        this.indicatorBorderSizeCriteria$delegate = ViewPropertyKt.viewProperty((View)this, Float.valueOf(10.0f));
        this.indicatorDrawable$delegate = ViewPropertyKt.viewProperty((View)this, null);
        this.supportRtlEnabled$delegate = ViewPropertyKt.viewProperty((View)this, true);
        this.placeholder$delegate = ViewPropertyKt.viewProperty((View)this, null);
        this.errorPlaceholder$delegate = ViewPropertyKt.viewProperty((View)this, null);
        this.maxSectionSize = 4;
        this.coroutineContext = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getMain().getImmediate());
        this.initAttributes(attrs, defStyleAttr);
    }

    public /* synthetic */ AvatarView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @Px
    public final int getAvatarBorderWidth() {
        return ((Number)this.avatarBorderWidth$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    public final void setAvatarBorderWidth(int n) {
        this.avatarBorderWidth$delegate.setValue((Object)this, $$delegatedProperties[0], n);
    }

    @ColorInt
    public final int getAvatarBorderColor() {
        return ((Number)this.avatarBorderColor$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    public final void setAvatarBorderColor(int n) {
        this.avatarBorderColor$delegate.setValue((Object)this, $$delegatedProperties[1], n);
    }

    @Px
    public final float getAvatarBorderRadius() {
        return ((Number)this.avatarBorderRadius$delegate.getValue((Object)this, $$delegatedProperties[2])).floatValue();
    }

    public final void setAvatarBorderRadius(float f) {
        this.avatarBorderRadius$delegate.setValue((Object)this, $$delegatedProperties[2], Float.valueOf(f));
    }

    @NotNull
    public final AvatarShape getAvatarShape() {
        return (AvatarShape)((Object)this.avatarShape$delegate.getValue((Object)this, $$delegatedProperties[3]));
    }

    public final void setAvatarShape(@NotNull AvatarShape avatarShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)avatarShape), (String)"<set-?>");
        this.avatarShape$delegate.setValue((Object)this, $$delegatedProperties[3], avatarShape);
    }

    @Nullable
    public final String getAvatarInitials() {
        return (String)this.avatarInitials$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    public final void setAvatarInitials(@Nullable String string) {
        this.avatarInitials$delegate.setValue((Object)this, $$delegatedProperties[4], string);
    }

    @Px
    public final int getAvatarInitialsTextSize() {
        return ((Number)this.avatarInitialsTextSize$delegate.getValue((Object)this, $$delegatedProperties[5])).intValue();
    }

    public final void setAvatarInitialsTextSize(int n) {
        this.avatarInitialsTextSize$delegate.setValue((Object)this, $$delegatedProperties[5], n);
    }

    @FloatRange(from=0.0, to=1.0)
    public final float getAvatarInitialsTextSizeRatio() {
        return ((Number)this.avatarInitialsTextSizeRatio$delegate.getValue((Object)this, $$delegatedProperties[6])).floatValue();
    }

    public final void setAvatarInitialsTextSizeRatio(float f) {
        this.avatarInitialsTextSizeRatio$delegate.setValue((Object)this, $$delegatedProperties[6], Float.valueOf(f));
    }

    @ColorInt
    public final int getAvatarInitialsTextColor() {
        return ((Number)this.avatarInitialsTextColor$delegate.getValue((Object)this, $$delegatedProperties[7])).intValue();
    }

    public final void setAvatarInitialsTextColor(int n) {
        this.avatarInitialsTextColor$delegate.setValue((Object)this, $$delegatedProperties[7], n);
    }

    public final int getAvatarInitialsStyle() {
        return ((Number)this.avatarInitialsStyle$delegate.getValue((Object)this, $$delegatedProperties[8])).intValue();
    }

    public final void setAvatarInitialsStyle(int n) {
        this.avatarInitialsStyle$delegate.setValue((Object)this, $$delegatedProperties[8], n);
    }

    @ColorInt
    public final int getAvatarInitialsBackgroundColor() {
        return ((Number)this.avatarInitialsBackgroundColor$delegate.getValue((Object)this, $$delegatedProperties[9])).intValue();
    }

    public final void setAvatarInitialsBackgroundColor(int n) {
        this.avatarInitialsBackgroundColor$delegate.setValue((Object)this, $$delegatedProperties[9], n);
    }

    public final boolean getIndicatorEnabled() {
        return (Boolean)this.indicatorEnabled$delegate.getValue((Object)this, $$delegatedProperties[10]);
    }

    public final void setIndicatorEnabled(boolean bl) {
        this.indicatorEnabled$delegate.setValue((Object)this, $$delegatedProperties[10], bl);
    }

    @NotNull
    public final IndicatorPosition getIndicatorPosition() {
        return (IndicatorPosition)((Object)this.indicatorPosition$delegate.getValue((Object)this, $$delegatedProperties[11]));
    }

    public final void setIndicatorPosition(@NotNull IndicatorPosition indicatorPosition) {
        Intrinsics.checkNotNullParameter((Object)((Object)indicatorPosition), (String)"<set-?>");
        this.indicatorPosition$delegate.setValue((Object)this, $$delegatedProperties[11], indicatorPosition);
    }

    @ColorInt
    public final int getIndicatorColor() {
        return ((Number)this.indicatorColor$delegate.getValue((Object)this, $$delegatedProperties[12])).intValue();
    }

    public final void setIndicatorColor(int n) {
        this.indicatorColor$delegate.setValue((Object)this, $$delegatedProperties[12], n);
    }

    @ColorInt
    public final int getIndicatorBorderColor() {
        return ((Number)this.indicatorBorderColor$delegate.getValue((Object)this, $$delegatedProperties[13])).intValue();
    }

    public final void setIndicatorBorderColor(int n) {
        this.indicatorBorderColor$delegate.setValue((Object)this, $$delegatedProperties[13], n);
    }

    public final float getIndicatorSizeCriteria() {
        return ((Number)this.indicatorSizeCriteria$delegate.getValue((Object)this, $$delegatedProperties[14])).floatValue();
    }

    public final void setIndicatorSizeCriteria(float f) {
        this.indicatorSizeCriteria$delegate.setValue((Object)this, $$delegatedProperties[14], Float.valueOf(f));
    }

    public final float getIndicatorBorderSizeCriteria() {
        return ((Number)this.indicatorBorderSizeCriteria$delegate.getValue((Object)this, $$delegatedProperties[15])).floatValue();
    }

    public final void setIndicatorBorderSizeCriteria(float f) {
        this.indicatorBorderSizeCriteria$delegate.setValue((Object)this, $$delegatedProperties[15], Float.valueOf(f));
    }

    @Nullable
    public final Drawable getIndicatorDrawable() {
        return (Drawable)this.indicatorDrawable$delegate.getValue((Object)this, $$delegatedProperties[16]);
    }

    public final void setIndicatorDrawable(@Nullable Drawable drawable) {
        this.indicatorDrawable$delegate.setValue((Object)this, $$delegatedProperties[16], drawable);
    }

    public final boolean getSupportRtlEnabled() {
        return (Boolean)this.supportRtlEnabled$delegate.getValue((Object)this, $$delegatedProperties[17]);
    }

    public final void setSupportRtlEnabled(boolean bl) {
        this.supportRtlEnabled$delegate.setValue((Object)this, $$delegatedProperties[17], bl);
    }

    @Nullable
    public final Drawable getPlaceholder() {
        return (Drawable)this.placeholder$delegate.getValue((Object)this, $$delegatedProperties[18]);
    }

    public final void setPlaceholder(@Nullable Drawable drawable) {
        this.placeholder$delegate.setValue((Object)this, $$delegatedProperties[18], drawable);
    }

    @Nullable
    public final Drawable getErrorPlaceholder() {
        return (Drawable)this.errorPlaceholder$delegate.getValue((Object)this, $$delegatedProperties[19]);
    }

    public final void setErrorPlaceholder(@Nullable Drawable drawable) {
        this.errorPlaceholder$delegate.setValue((Object)this, $$delegatedProperties[19], drawable);
    }

    public final int getMaxSectionSize() {
        return this.maxSectionSize;
    }

    public final void setMaxSectionSize(int value) {
        this.maxSectionSize = RangesKt.coerceIn((int)value, (ClosedRange)((ClosedRange)new IntRange(1, 4)));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @InternalAvatarViewApi
    public static /* synthetic */ void getCoroutineContext$annotations() {
    }

    private final void initAttributes(AttributeSet attrs, int defStyleAttr) {
        Enum default$iv;
        int index$iv;
        TypedArray $this$getEnum$iv;
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.AvatarView, defStyleAttr, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026tarView, defStyleAttr, 0)");
        TypedArray $this$use$iv = typedArray;
        boolean $i$f$use = false;
        TypedArray typedArray2 = $this$use$iv;
        boolean bl = false;
        this.setAvatarBorderWidth(typedArray2.getDimensionPixelSize(R.styleable.AvatarView_avatarViewBorderWidth, this.getAvatarBorderWidth()));
        this.setAvatarBorderColor(typedArray2.getColor(R.styleable.AvatarView_avatarViewBorderColor, this.getAvatarBorderColor()));
        this.setAvatarBorderRadius(typedArray2.getDimension(R.styleable.AvatarView_avatarViewBorderRadius, this.getAvatarBorderRadius()));
        this.setAvatarInitials(typedArray2.getString(R.styleable.AvatarView_avatarViewInitials));
        this.setAvatarInitialsTextSize(typedArray2.getDimensionPixelSize(R.styleable.AvatarView_avatarViewInitialsTextSize, this.getAvatarInitialsTextSize()));
        this.setAvatarInitialsTextSizeRatio(typedArray2.getFloat(R.styleable.AvatarView_avatarViewInitialsTextSizeRatio, this.getAvatarInitialsTextSizeRatio()));
        this.setAvatarInitialsTextColor(typedArray2.getColor(R.styleable.AvatarView_avatarViewInitialsTextColor, this.getAvatarInitialsTextColor()));
        this.setAvatarInitialsBackgroundColor(typedArray2.getColor(R.styleable.AvatarView_avatarViewInitialsBackgroundColor, this.getAvatarInitialsBackgroundColor()));
        this.setAvatarInitialsStyle(typedArray2.getInt(R.styleable.AvatarView_avatarViewInitialsTextStyle, this.getAvatarInitialsStyle()));
        TypedArray typedArray3 = typedArray2;
        int n = R.styleable.AvatarView_avatarViewShape;
        Enum enum_ = this.getAvatarShape();
        boolean $i$f$getEnum = false;
        int it$iv = $this$getEnum$iv.getInt(index$iv, -1);
        boolean bl2 = false;
        this.setAvatarShape((AvatarShape)(it$iv >= 0 ? (Enum)AvatarShape.values()[it$iv] : default$iv));
        this.setIndicatorEnabled(typedArray2.getBoolean(R.styleable.AvatarView_avatarViewIndicatorEnabled, this.getIndicatorEnabled()));
        $this$getEnum$iv = typedArray2;
        index$iv = R.styleable.AvatarView_avatarViewIndicatorPosition;
        default$iv = this.getIndicatorPosition();
        $i$f$getEnum = false;
        it$iv = $this$getEnum$iv.getInt(index$iv, -1);
        bl2 = false;
        this.setIndicatorPosition((IndicatorPosition)(it$iv >= 0 ? (Enum)IndicatorPosition.values()[it$iv] : default$iv));
        this.setIndicatorColor(typedArray2.getColor(R.styleable.AvatarView_avatarViewIndicatorColor, this.getIndicatorColor()));
        this.setIndicatorBorderColor(typedArray2.getColor(R.styleable.AvatarView_avatarViewIndicatorBorderColor, this.getIndicatorBorderColor()));
        this.setIndicatorSizeCriteria(typedArray2.getFloat(R.styleable.AvatarView_avatarViewIndicatorSizeCriteria, this.getIndicatorSizeCriteria()));
        this.setIndicatorBorderSizeCriteria(typedArray2.getFloat(R.styleable.AvatarView_avatarViewIndicatorBorderSizeCriteria, this.getIndicatorBorderSizeCriteria()));
        this.setIndicatorDrawable(typedArray2.getDrawable(R.styleable.AvatarView_avatarViewIndicatorDrawable));
        this.setSupportRtlEnabled(typedArray2.getBoolean(R.styleable.AvatarView_avatarViewSupportRtlEnabled, this.getSupportRtlEnabled()));
        this.setMaxSectionSize(typedArray2.getInt(R.styleable.AvatarView_avatarViewMaxSectionSize, this.getMaxSectionSize()));
        this.setPlaceholder(typedArray2.getDrawable(R.styleable.AvatarView_avatarViewPlaceholder));
        this.setErrorPlaceholder(typedArray2.getDrawable(R.styleable.AvatarView_avatarViewErrorPlaceholder));
        $this$use$iv.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = AppCompatImageView.resolveSize((int)0, (int)widthMeasureSpec);
        int height = AppCompatImageView.resolveSize((int)0, (int)heightMeasureSpec);
        int avatarViewSize = RangesKt.coerceAtMost((int)width, (int)height);
        this.setMeasuredDimension(avatarViewSize, avatarViewSize);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        CharSequence charSequence = this.getAvatarInitials();
        if (charSequence == null || charSequence.length() == 0) {
            if (this.getDrawable() != null) {
                super.onDraw(canvas);
                this.applyPaintStyles();
                this.drawBorder(canvas);
                this.drawIndicator(canvas);
            }
        } else {
            this.applyPaintStyles();
            this.drawColor(canvas);
            this.drawInitials(canvas);
            this.drawBorder(canvas);
            this.drawIndicator(canvas);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyPaintStyles() {
        void it;
        this.borderPaint.setColor(this.getAvatarBorderColor());
        this.borderPaint.setStrokeWidth((float)this.getAvatarBorderWidth());
        int padding = RangesKt.coerceAtLeast((int)(this.getAvatarBorderWidth() - 1), (int)0);
        this.setPadding(padding, padding, padding, padding);
        this.indicatorOutlinePaint.setColor(this.getIndicatorBorderColor());
        this.indicatorPaint.setColor(this.getIndicatorColor());
        this.backgroundPaint.setColor(this.getAvatarInitialsBackgroundColor());
        this.textPaint.setColor(this.getAvatarInitialsTextColor());
        this.textPaint.setTypeface(Typeface.defaultFromStyle((int)this.getAvatarInitialsStyle()));
        Integer n = this.getAvatarInitialsTextSize();
        int n2 = ((Number)n).intValue();
        Paint paint = this.textPaint;
        boolean bl = false;
        boolean bl2 = it != -1;
        Integer n3 = bl2 ? n : null;
        Float f = n3 == null ? null : Float.valueOf(n3.intValue());
        paint.setTextSize(f == null ? this.getAvatarInitialsTextSizeRatio() * (float)this.getWidth() : f.floatValue());
    }

    private final void drawBorder(Canvas canvas) {
        if (this.getAvatarBorderWidth() == 0) {
            return;
        }
        if (this.getAvatarShape() == AvatarShape.ROUNDED_RECT) {
            canvas.drawRoundRect(4.0f, 4.0f, (float)this.getWidth() - 4.0f, (float)this.getHeight() - 4.0f, this.getAvatarBorderRadius(), this.getAvatarBorderRadius(), this.borderPaint);
        } else {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.getWidth() / 2.0f - (float)(this.getAvatarBorderWidth() / 2), this.borderPaint);
        }
    }

    private final void drawInitials(Canvas canvas) {
        String initials;
        String string = this.getAvatarInitials();
        if (string == null) {
            return;
        }
        String $this$parseInitials$iv = initials = string;
        boolean $i$f$getParseInitials = false;
        String[] stringArray = new String[]{" "};
        List textList$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)$this$parseInitials$iv)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string2 = (textList$iv.size() > 1 ? "" + ((String)textList$iv.get(0)).charAt(0) + ((String)textList$iv.get(1)).charAt(0) : (((String)textList$iv.get(0)).length() > 1 ? "" + ((String)textList$iv.get(0)).charAt(0) + ((String)textList$iv.get(0)).charAt(1) : (((CharSequence)textList$iv.get(0)).length() > 0 ? String.valueOf(((String)textList$iv.get(0)).charAt(0)) : ""))).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        canvas.drawText(string2, (float)this.getWidth() / (float)2, (float)(canvas.getHeight() / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / (float)2, this.textPaint);
    }

    private final void drawColor(Canvas canvas) {
        if (this.getAvatarShape() == AvatarShape.ROUNDED_RECT) {
            canvas.drawRoundRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.getAvatarBorderRadius(), this.getAvatarBorderRadius(), this.backgroundPaint);
        } else {
            canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, (float)this.getWidth() / 2.0f, this.backgroundPaint);
        }
    }

    private final void drawIndicator(Canvas canvas) {
        if (this.getIndicatorEnabled()) {
            boolean isRtlEnabled = this.getSupportRtlEnabled() && ExtensionsKt.isRtlLayout((View)this);
            Drawable customIndicator = this.getIndicatorDrawable();
            if (customIndicator != null) {
                float f;
                float f2;
                Drawable $this$drawIndicator_u24lambda_u2d7 = customIndicator;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getIndicatorPosition().ordinal()]) {
                    case 1: 
                    case 2: {
                        if (isRtlEnabled) {
                            f2 = (float)this.getWidth() - (float)this.getWidth() / this.getIndicatorSizeCriteria();
                            break;
                        }
                        f2 = 0.0f;
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (isRtlEnabled) {
                            f2 = (float)this.getWidth() / this.getIndicatorSizeCriteria();
                            break;
                        }
                        f2 = (float)this.getWidth() - (float)this.getWidth() / this.getIndicatorSizeCriteria();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                float cx = f2;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getIndicatorPosition().ordinal()]) {
                    case 1: 
                    case 3: {
                        f = 0.0f;
                        break;
                    }
                    case 2: 
                    case 4: {
                        f = (float)this.getHeight() - (float)this.getHeight() / this.getIndicatorSizeCriteria();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                float cy = f;
                $this$drawIndicator_u24lambda_u2d7.setBounds((int)cx, (int)cy, (int)(cx + (float)this.getWidth() / this.getIndicatorSizeCriteria()), (int)(cy + (float)this.getHeight() / this.getIndicatorSizeCriteria()));
                $this$drawIndicator_u24lambda_u2d7.draw(canvas);
            } else {
                float f;
                float f3;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getIndicatorPosition().ordinal()]) {
                    case 1: 
                    case 2: {
                        if (isRtlEnabled) {
                            f3 = (float)this.getWidth() - (float)this.getWidth() / this.getIndicatorSizeCriteria();
                            break;
                        }
                        f3 = (float)this.getWidth() / this.getIndicatorSizeCriteria();
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (isRtlEnabled) {
                            f3 = (float)this.getWidth() / this.getIndicatorSizeCriteria();
                            break;
                        }
                        f3 = (float)this.getWidth() - (float)this.getWidth() / this.getIndicatorSizeCriteria();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                float cx = f3;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getIndicatorPosition().ordinal()]) {
                    case 1: 
                    case 3: {
                        f = (float)this.getHeight() / this.getIndicatorSizeCriteria();
                        break;
                    }
                    case 2: 
                    case 4: {
                        f = (float)this.getHeight() - (float)this.getHeight() / this.getIndicatorSizeCriteria();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                float cy = f;
                canvas.drawCircle(cx, cy, (float)this.getWidth() / this.getIndicatorSizeCriteria(), this.indicatorOutlinePaint);
                canvas.drawCircle(cx, cy, (float)this.getWidth() / this.getIndicatorBorderSizeCriteria(), this.indicatorPaint);
            }
        }
    }

    public final void setIndicatorRes(@DrawableRes int drawableRes) {
        this.setIndicatorDrawable(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)drawableRes, null));
    }

    protected void onDetachedFromWindow() {
        JobKt.cancel$default((CoroutineContext)this.getCoroutineContext(), null, (int)1, null);
        super.onDetachedFromWindow();
    }

    @JvmOverloads
    public AvatarView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AvatarView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarBorderWidth", "getAvatarBorderWidth()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarBorderColor", "getAvatarBorderColor()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarBorderRadius", "getAvatarBorderRadius()F", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarShape", "getAvatarShape()Lio/getstream/avatarview/AvatarShape;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarInitials", "getAvatarInitials()Ljava/lang/String;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarInitialsTextSize", "getAvatarInitialsTextSize()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarInitialsTextSizeRatio", "getAvatarInitialsTextSizeRatio()F", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarInitialsTextColor", "getAvatarInitialsTextColor()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarInitialsStyle", "getAvatarInitialsStyle()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "avatarInitialsBackgroundColor", "getAvatarInitialsBackgroundColor()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "indicatorEnabled", "getIndicatorEnabled()Z", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "indicatorPosition", "getIndicatorPosition()Lio/getstream/avatarview/IndicatorPosition;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "indicatorColor", "getIndicatorColor()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "indicatorBorderColor", "getIndicatorBorderColor()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "indicatorSizeCriteria", "getIndicatorSizeCriteria()F", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "indicatorBorderSizeCriteria", "getIndicatorBorderSizeCriteria()F", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "indicatorDrawable", "getIndicatorDrawable()Landroid/graphics/drawable/Drawable;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "supportRtlEnabled", "getSupportRtlEnabled()Z", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "placeholder", "getPlaceholder()Landroid/graphics/drawable/Drawable;", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AvatarView.class, "errorPlaceholder", "getErrorPlaceholder()Landroid/graphics/drawable/Drawable;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/getstream/avatarview/AvatarView$Companion;", "", "()V", "AVATAR_SIZE_EXTRA", "", "BORDER_OFFSET", "", "avatarview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IndicatorPosition.values().length];
            nArray[IndicatorPosition.TOP_LEFT.ordinal()] = 1;
            nArray[IndicatorPosition.BOTTOM_LEFT.ordinal()] = 2;
            nArray[IndicatorPosition.TOP_RIGHT.ordinal()] = 3;
            nArray[IndicatorPosition.BOTTOM_RIGHT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

