/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.avatarview;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.VectorDrawable;
import android.media.ThumbnailUtils;
import androidx.annotation.Px;
import io.getstream.avatarview.internal.InternalAvatarViewApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001f B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0005\u001a\u00020\u00062\u0016\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\b\"\u0004\u0018\u00010\u00062\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ4\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000f2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u0014\u001a\u00020\u0006*\u00020\u00152\b\b\u0001\u0010\t\u001a\u00020\nH\u0002J \u0010\u0016\u001a\u00020\u0006*\u00020\u00062\b\b\u0001\u0010\u0017\u001a\u00020\n2\b\b\u0001\u0010\u0018\u001a\u00020\nH\u0002J\u001e\u0010\u0019\u001a\u00020\u0011*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u0006*\u00020\r2\b\b\u0001\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u001d\u001a\u00020\u0006*\u00020\u001e2\b\b\u0001\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/getstream/avatarview/AvatarBitmapCombiner;", "", "()V", "paint", "Landroid/graphics/Paint;", "combine", "Landroid/graphics/Bitmap;", "bitmaps", "", "size", "", "maxSectionSize", "errorPlaceholder", "Landroid/graphics/drawable/Drawable;", "([Landroid/graphics/Bitmap;IILandroid/graphics/drawable/Drawable;)Landroid/graphics/Bitmap;", "", "createAvatarItems", "Lio/getstream/avatarview/AvatarBitmapCombiner$AvatarItem;", "drawableToBitmap", "drawable", "bitmapDrawableToBitmap", "Landroid/graphics/drawable/BitmapDrawable;", "scaleCenterCrop", "newWidth", "newHeight", "toAvatarItem", "sectionType", "Lio/getstream/avatarview/AvatarBitmapCombiner$SectionType;", "toBitmap", "vectorDrawableToBitmap", "Landroid/graphics/drawable/VectorDrawable;", "AvatarItem", "SectionType", "avatarview_release"})
public final class AvatarBitmapCombiner {
    @NotNull
    public static final AvatarBitmapCombiner INSTANCE;
    @NotNull
    private static final Paint paint;

    private AvatarBitmapCombiner() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bitmap combine(@NotNull List<Bitmap> bitmaps, @Px int size, int maxSectionSize, @Nullable Drawable errorPlaceholder) {
        void $this$mapNotNullTo$iv$iv;
        Canvas c$iv;
        Intrinsics.checkNotNullParameter(bitmaps, (String)"bitmaps");
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(size, size, Bitmap.Config.ARGB_8888)");
        Bitmap $this$applyCanvas$iv = bitmap;
        boolean $i$f$applyCanvas = false;
        Canvas $this$combine_u24lambda_u243 = c$iv = new Canvas($this$applyCanvas$iv);
        boolean bl = false;
        Rect sourceRect = new Rect(0, 0, size, size);
        Iterable $this$mapNotNull$iv = bitmaps;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Bitmap bitmap2 = (Bitmap)element$iv$iv;
            boolean bl3 = false;
            Bitmap bitmap3 = bitmap2;
            if (bitmap3 == null) {
                bitmap3 = INSTANCE.drawableToBitmap(errorPlaceholder, size);
            }
            if (bitmap3 == null) continue;
            Bitmap it$iv$iv = bitmap3;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List mappedBitmaps = (List)destination$iv$iv;
        Iterable $this$forEach$iv = INSTANCE.createAvatarItems(mappedBitmaps, size, maxSectionSize);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            AvatarItem it = (AvatarItem)element$iv;
            boolean bl5 = false;
            $this$combine_u24lambda_u243.drawBitmap(it.getBitmap(), sourceRect, it.getPosition(), paint);
        }
        return $this$applyCanvas$iv;
    }

    public static /* synthetic */ Bitmap combine$default(AvatarBitmapCombiner avatarBitmapCombiner, List list, int n, int n2, Drawable drawable, int n3, Object object) {
        if ((n3 & 8) != 0) {
            drawable = null;
        }
        return avatarBitmapCombiner.combine(list, n, n2, drawable);
    }

    @NotNull
    public final Bitmap combine(@NotNull Bitmap[] bitmaps, @Px int size, int maxSectionSize, @Nullable Drawable errorPlaceholder) {
        Intrinsics.checkNotNullParameter((Object)bitmaps, (String)"bitmaps");
        return this.combine(ArraysKt.toList((Object[])bitmaps), size, maxSectionSize, errorPlaceholder);
    }

    public static /* synthetic */ Bitmap combine$default(AvatarBitmapCombiner avatarBitmapCombiner, Bitmap[] bitmapArray, int n, int n2, Drawable drawable, int n3, Object object) {
        if ((n3 & 8) != 0) {
            drawable = null;
        }
        return avatarBitmapCombiner.combine(bitmapArray, n, n2, drawable);
    }

    private final List<AvatarItem> createAvatarItems(List<Bitmap> bitmaps, @Px int size, int maxSectionSize) {
        List list;
        List avatarBitmaps = CollectionsKt.take((Iterable)bitmaps, (int)maxSectionSize);
        switch (avatarBitmaps.size()) {
            case 0: {
                list = CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list = CollectionsKt.listOf((Object)this.toAvatarItem((Bitmap)avatarBitmaps.get(0), SectionType.FULL_CIRCLE, size));
                break;
            }
            case 2: {
                Object[] objectArray = new AvatarItem[]{this.toAvatarItem((Bitmap)avatarBitmaps.get(0), SectionType.LEFT, size), this.toAvatarItem((Bitmap)avatarBitmaps.get(1), SectionType.RIGHT, size)};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            case 3: {
                Object[] objectArray = new AvatarItem[]{this.toAvatarItem((Bitmap)avatarBitmaps.get(0), SectionType.TOP_LEFT, size), this.toAvatarItem((Bitmap)avatarBitmaps.get(1), SectionType.TOP_RIGHT, size), this.toAvatarItem((Bitmap)avatarBitmaps.get(2), SectionType.BOTTOM, size)};
                list = CollectionsKt.listOf((Object[])objectArray);
                break;
            }
            default: {
                Object[] objectArray = new AvatarItem[]{this.toAvatarItem((Bitmap)avatarBitmaps.get(0), SectionType.TOP_LEFT, size), this.toAvatarItem((Bitmap)avatarBitmaps.get(1), SectionType.TOP_RIGHT, size), this.toAvatarItem((Bitmap)avatarBitmaps.get(2), SectionType.BOTTOM_LEFT, size), this.toAvatarItem((Bitmap)avatarBitmaps.get(3), SectionType.BOTTOM_RIGHT, size)};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        }
        return list;
    }

    private final AvatarItem toAvatarItem(Bitmap $this$toAvatarItem, SectionType sectionType, @Px int size) {
        AvatarItem avatarItem;
        switch (WhenMappings.$EnumSwitchMapping$0[sectionType.ordinal()]) {
            case 1: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size, size), new Rect(0, 0, size, size));
                break;
            }
            case 2: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size / 2, size), new Rect(0, 0, size, size));
                break;
            }
            case 3: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size / 2, size), new Rect(size / 2, 0, size + size / 2, size));
                break;
            }
            case 4: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size, size / 2), new Rect(0, size / 2, size, size + size / 2));
                break;
            }
            case 5: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size, size), new Rect(0, 0, size / 2, size / 2));
                break;
            }
            case 6: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size, size), new Rect(size / 2, 0, size, size / 2));
                break;
            }
            case 7: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size, size), new Rect(0, size / 2, size / 2, size));
                break;
            }
            case 8: {
                avatarItem = new AvatarItem(this.scaleCenterCrop($this$toAvatarItem, size, size), new Rect(size / 2, size / 2, size, size));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return avatarItem;
    }

    private final Bitmap scaleCenterCrop(Bitmap $this$scaleCenterCrop, @Px int newWidth, @Px int newHeight) {
        Bitmap bitmap = ThumbnailUtils.extractThumbnail((Bitmap)$this$scaleCenterCrop, (int)newWidth, (int)newHeight);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"extractThumbnail(this, newWidth, newHeight)");
        return bitmap;
    }

    @InternalAvatarViewApi
    @Nullable
    public final Bitmap drawableToBitmap(@Nullable Drawable drawable, @Px int size) {
        Object object;
        if (drawable instanceof VectorDrawable) {
            object = this.vectorDrawableToBitmap((VectorDrawable)drawable, size);
        } else if (drawable instanceof BitmapDrawable) {
            object = this.bitmapDrawableToBitmap((BitmapDrawable)drawable, size);
        } else {
            Drawable drawable2 = drawable;
            object = drawable2 != null ? this.toBitmap(drawable2, size) : null;
        }
        return object;
    }

    private final Bitmap vectorDrawableToBitmap(VectorDrawable $this$vectorDrawableToBitmap, @Px int size) {
        Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        $this$vectorDrawableToBitmap.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        $this$vectorDrawableToBitmap.draw(canvas);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bitmap");
        return bitmap;
    }

    private final Bitmap bitmapDrawableToBitmap(BitmapDrawable $this$bitmapDrawableToBitmap, @Px int size) {
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)$this$bitmapDrawableToBitmap.getBitmap(), (int)size, (int)size, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createScaledBitmap(bitmap, size, size, false)");
        return bitmap;
    }

    private final Bitmap toBitmap(Drawable $this$toBitmap, @Px int size) {
        Bitmap bitmap;
        try {
            Bitmap bitmap2 = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap2);
            $this$toBitmap.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            $this$toBitmap.draw(canvas);
        }
        catch (Exception e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    static {
        Paint paint;
        INSTANCE = new AvatarBitmapCombiner();
        Paint $this$paint_u24lambda_u240 = paint = new Paint(1);
        boolean bl = false;
        $this$paint_u24lambda_u240.setAntiAlias(true);
        $this$paint_u24lambda_u240.setFilterBitmap(true);
        $this$paint_u24lambda_u240.setDither(true);
        AvatarBitmapCombiner.paint = paint;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lio/getstream/avatarview/AvatarBitmapCombiner$AvatarItem;", "", "bitmap", "Landroid/graphics/Bitmap;", "position", "Landroid/graphics/Rect;", "(Landroid/graphics/Bitmap;Landroid/graphics/Rect;)V", "getBitmap", "()Landroid/graphics/Bitmap;", "getPosition", "()Landroid/graphics/Rect;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "avatarview_release"})
    private static final class AvatarItem {
        @NotNull
        private final Bitmap bitmap;
        @NotNull
        private final Rect position;

        public AvatarItem(@NotNull Bitmap bitmap, @NotNull Rect position) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.bitmap = bitmap;
            this.position = position;
        }

        @NotNull
        public final Bitmap getBitmap() {
            return this.bitmap;
        }

        @NotNull
        public final Rect getPosition() {
            return this.position;
        }

        @NotNull
        public final Bitmap component1() {
            return this.bitmap;
        }

        @NotNull
        public final Rect component2() {
            return this.position;
        }

        @NotNull
        public final AvatarItem copy(@NotNull Bitmap bitmap, @NotNull Rect position) {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new AvatarItem(bitmap, position);
        }

        public static /* synthetic */ AvatarItem copy$default(AvatarItem avatarItem, Bitmap bitmap, Rect rect, int n, Object object) {
            if ((n & 1) != 0) {
                bitmap = avatarItem.bitmap;
            }
            if ((n & 2) != 0) {
                rect = avatarItem.position;
            }
            return avatarItem.copy(bitmap, rect);
        }

        @NotNull
        public String toString() {
            return "AvatarItem(bitmap=" + this.bitmap + ", position=" + this.position + ')';
        }

        public int hashCode() {
            int result = this.bitmap.hashCode();
            result = result * 31 + this.position.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AvatarItem)) {
                return false;
            }
            AvatarItem avatarItem = (AvatarItem)other;
            if (!Intrinsics.areEqual((Object)this.bitmap, (Object)avatarItem.bitmap)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.position, (Object)avatarItem.position);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lio/getstream/avatarview/AvatarBitmapCombiner$SectionType;", "", "(Ljava/lang/String;I)V", "FULL_CIRCLE", "LEFT", "RIGHT", "BOTTOM", "TOP_LEFT", "TOP_RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT", "avatarview_release"})
    private static final class SectionType
    extends Enum<SectionType> {
        public static final /* enum */ SectionType FULL_CIRCLE = new SectionType();
        public static final /* enum */ SectionType LEFT = new SectionType();
        public static final /* enum */ SectionType RIGHT = new SectionType();
        public static final /* enum */ SectionType BOTTOM = new SectionType();
        public static final /* enum */ SectionType TOP_LEFT = new SectionType();
        public static final /* enum */ SectionType TOP_RIGHT = new SectionType();
        public static final /* enum */ SectionType BOTTOM_LEFT = new SectionType();
        public static final /* enum */ SectionType BOTTOM_RIGHT = new SectionType();
        private static final /* synthetic */ SectionType[] $VALUES;

        public static SectionType[] values() {
            return (SectionType[])$VALUES.clone();
        }

        public static SectionType valueOf(String value) {
            return Enum.valueOf(SectionType.class, value);
        }

        static {
            $VALUES = sectionTypeArray = new SectionType[]{SectionType.FULL_CIRCLE, SectionType.LEFT, SectionType.RIGHT, SectionType.BOTTOM, SectionType.TOP_LEFT, SectionType.TOP_RIGHT, SectionType.BOTTOM_LEFT, SectionType.BOTTOM_RIGHT};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SectionType.values().length];
            try {
                nArray[SectionType.FULL_CIRCLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.TOP_LEFT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.TOP_RIGHT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.BOTTOM_LEFT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SectionType.BOTTOM_RIGHT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

