/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client;

import io.getstream.client.AggregatedFeed;
import io.getstream.client.Client;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.models.Activity;
import io.getstream.core.models.EnrichedActivity;
import io.getstream.core.models.FeedID;
import io.getstream.core.models.NotificationGroup;
import io.getstream.core.options.ActivityMarker;
import io.getstream.core.options.Filter;
import io.getstream.core.options.Pagination;
import io.getstream.core.utils.DefaultOptions;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class NotificationFeed
extends AggregatedFeed {
    NotificationFeed(Client client, FeedID id) {
        super(client, id);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities() throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Pagination pagination) throws StreamException {
        return this.getActivities(pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Filter filter) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(ActivityMarker marker) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Filter filter, ActivityMarker marker) throws StreamException {
        return this.getActivities(DefaultOptions.DEFAULT_PAGINATION, filter, marker);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getActivities(pagination, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Pagination pagination, Filter filter) throws StreamException {
        return this.getActivities(pagination, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<Activity>>> getActivities(Pagination pagination, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getActivities(this.getID(), pagination, filter, marker).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, Activity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Pagination pagination) throws StreamException {
        return this.getCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Pagination pagination, Filter filter) throws StreamException {
        return this.getCustomActivities(type, pagination, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getCustomActivities(Class<T> type, Pagination pagination, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getActivities(this.getID(), pagination, filter, marker).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities() throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Filter filter) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Filter filter, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(DefaultOptions.DEFAULT_PAGINATION, filter, marker);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getEnrichedActivities(pagination, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination, Filter filter) throws StreamException {
        return this.getEnrichedActivities(pagination, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public CompletableFuture<List<NotificationGroup<EnrichedActivity>>> getEnrichedActivities(Pagination pagination, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getEnrichedActivities(this.getID(), pagination, filter, marker).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, EnrichedActivity.class);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getCustomActivities(type, DefaultOptions.DEFAULT_PAGINATION, filter, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, ActivityMarker marker) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, DefaultOptions.DEFAULT_FILTER, marker);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, Filter filter) throws StreamException {
        return this.getEnrichedCustomActivities(type, pagination, filter, DefaultOptions.DEFAULT_MARKER);
    }

    public <T> CompletableFuture<List<NotificationGroup<T>>> getEnrichedCustomActivities(Class<T> type, Pagination pagination, Filter filter, ActivityMarker marker) throws StreamException {
        return this.getClient().getEnrichedActivities(this.getID(), pagination, filter, marker).thenApply(response -> {
            try {
                return (List)Serialization.deserializeContainer(response, NotificationGroup.class, type);
            }
            catch (StreamException | IOException e) {
                throw new CompletionException(e);
            }
        });
    }
}

