/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Token;
import io.getstream.core.models.CollectionData;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;

public final class StreamCollections {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    StreamCollections(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<CollectionData> add(Token token, final String userID, String collection, final CollectionData item) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)item, (Object)"Collection data can't be null");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final String user_id;
                public final Map<String, Object> data;
                {
                    this.user_id = (String)MoreObjects.firstNonNull((Object)userID, (Object)"");
                    this.data = item.getData();
                }
            });
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/');
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, CollectionData.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<CollectionData> update(Token token, final String userID, String collection, final CollectionData item) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)item, (Object)"Collection data can't be null");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final String user_id;
                public final Map<String, Object> data;
                {
                    this.user_id = (String)MoreObjects.firstNonNull((Object)userID, (Object)"");
                    this.data = item.getData();
                }
            });
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/' + item.getID() + '/');
            return this.httpClient.execute(Request.buildPut(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, CollectionData.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> upsertMany(Token token, final String collection, final CollectionData ... items) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkArgument((items.length > 0 ? 1 : 0) != 0, (Object)"Collection data can't be empty");
        try {
            byte[] payload = Serialization.toJSON(new Object(){
                public final Map<String, CollectionData[]> data;
                {
                    this.data = ImmutableMap.of((Object)collection, (Object)items);
                }
            });
            URL url = Routes.buildBatchCollectionsURL(this.baseURL);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, payload, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<CollectionData>> items(Token token, String collection) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        try {
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/');
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeContainer(response, CollectionData.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<CollectionData> get(Token token, String collection, String id) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)id, (Object)"Collection id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Collection id can't be empty");
        try {
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/' + id + '/');
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, CollectionData.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<List<CollectionData>> getMany(Token token, String collection, String ... ids) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0, (Object)"Collection ids can't be empty");
        List foreignIDs = Arrays.stream(ids).map(id -> String.format("%s:%s", collection, id)).collect(Collectors.toList());
        try {
            URL url = Routes.buildBatchCollectionsURL(this.baseURL);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, new CustomQueryParameter("foreign_ids", String.join((CharSequence)",", foreignIDs)))).thenApply(response -> {
                try {
                    return Serialization.deserializeContainer(response, "response.data", CollectionData.class);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> delete(Token token, String collection, String id) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkNotNull((Object)id, (Object)"Collection id can't be null");
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0, (Object)"Collection id can't be empty");
        try {
            URL url = Routes.buildCollectionsURL(this.baseURL, collection + '/' + id + '/');
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, new RequestOption[0])).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> deleteMany(Token token, String collection, String ... ids) throws StreamException {
        Preconditions.checkNotNull((Object)collection, (Object)"Collection name can't be null");
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Collection name can't be empty");
        Preconditions.checkArgument((ids.length > 0 ? 1 : 0) != 0, (Object)"Collection ids can't be empty");
        try {
            URL url = Routes.buildBatchCollectionsURL(this.baseURL);
            RequestOption[] options = new RequestOption[]{new CustomQueryParameter("collection_name", collection), new CustomQueryParameter("ids", String.join((CharSequence)",", ids))};
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, options)).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }
}

