/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import io.getstream.core.exceptions.StreamException;
import io.getstream.core.http.HTTPClient;
import io.getstream.core.http.Token;
import io.getstream.core.options.CustomQueryParameter;
import io.getstream.core.options.RequestOption;
import io.getstream.core.utils.Request;
import io.getstream.core.utils.Routes;
import io.getstream.core.utils.Serialization;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class StreamPersonalization {
    private final String key;
    private final URL baseURL;
    private final HTTPClient httpClient;

    StreamPersonalization(String key, URL baseURL, HTTPClient httpClient) {
        this.key = key;
        this.baseURL = baseURL;
        this.httpClient = httpClient;
    }

    public CompletableFuture<Map<String, Object>> get(Token token, String userID, String resource, Map<String, Object> params) throws StreamException {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource can't be empty");
        Preconditions.checkArgument((!resource.isEmpty() ? 1 : 0) != 0, (Object)"Resource can't be empty");
        Preconditions.checkNotNull(params, (Object)"Missing params");
        try {
            URL url = Routes.buildPersonalizationURL(this.baseURL, resource + '/');
            RequestOption[] options = (RequestOption[])params.entrySet().stream().map(entry -> new CustomQueryParameter((String)entry.getKey(), entry.getValue().toString())).toArray(RequestOption[]::new);
            return this.httpClient.execute(Request.buildGet(url, this.key, token, options)).thenApply(response -> {
                try {
                    return Serialization.deserialize(response, new TypeReference<Map<String, Object>>(){});
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> post(Token token, String userID, String resource, Map<String, Object> params, final Map<String, Object> payload) throws StreamException {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource can't be empty");
        Preconditions.checkArgument((!resource.isEmpty() ? 1 : 0) != 0, (Object)"Resource can't be empty");
        Preconditions.checkNotNull(params, (Object)"Missing params");
        Preconditions.checkNotNull(params, (Object)"Missing payload");
        try {
            byte[] jsonPayload = Serialization.toJSON(new Object(){
                public final Map<String, Object> data;
                {
                    this.data = payload;
                }
            });
            URL url = Routes.buildPersonalizationURL(this.baseURL, resource + '/');
            RequestOption[] options = (RequestOption[])params.entrySet().stream().map(entry -> new CustomQueryParameter((String)entry.getKey(), entry.getValue().toString())).toArray(RequestOption[]::new);
            return this.httpClient.execute(Request.buildPost(url, this.key, token, jsonPayload, options)).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (JsonProcessingException | MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }

    public CompletableFuture<Void> delete(Token token, String userID, String resource, Map<String, Object> params) throws StreamException {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource can't be empty");
        Preconditions.checkArgument((!resource.isEmpty() ? 1 : 0) != 0, (Object)"Resource can't be empty");
        Preconditions.checkNotNull(params, (Object)"Missing params");
        try {
            URL url = Routes.buildPersonalizationURL(this.baseURL, resource + '/');
            RequestOption[] options = (RequestOption[])params.entrySet().stream().map(entry -> new CustomQueryParameter((String)entry.getKey(), entry.getValue().toString())).toArray(RequestOption[]::new);
            return this.httpClient.execute(Request.buildDelete(url, this.key, token, options)).thenApply(response -> {
                try {
                    return Serialization.deserializeError(response);
                }
                catch (StreamException | IOException e) {
                    throw new CompletionException(e);
                }
            });
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new StreamException(e);
        }
    }
}

