/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.getstream.core.utils.Serialization;
import java.util.Map;
import java.util.Objects;

public class CollectionData {
    private final String id;
    private final String collection;
    private final Map<String, Object> data;

    @JsonCreator
    public CollectionData(@JsonProperty(value="collection") String collection, @JsonProperty(value="id") String id, @JsonProperty(value="data") Map<String, Object> data) {
        this.collection = collection;
        this.data = (Map)MoreObjects.firstNonNull(data, (Object)Maps.newHashMap());
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"ID required");
    }

    public CollectionData() {
        this(null, "", null);
    }

    public CollectionData(String id) {
        this(null, id, null);
    }

    public static <T> CollectionData buildFrom(T data) {
        return Serialization.convert(data, CollectionData.class);
    }

    public String getID() {
        return this.id;
    }

    @JsonIgnore
    public String getCollection() {
        return this.collection;
    }

    @JsonAnyGetter
    public Map<String, Object> getData() {
        return this.data;
    }

    @JsonAnySetter
    public <T> CollectionData set(String key, T value) {
        Preconditions.checkArgument((!"id".equals(key) ? 1 : 0) != 0, (Object)"Key can't be named 'id'");
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null");
        Preconditions.checkNotNull(value, (Object)"Value can't be null");
        this.data.put(key, value);
        return this;
    }

    public <T> CollectionData from(T data) {
        Preconditions.checkNotNull(data, (Object)"Can't extract data from null");
        Map<String, Object> map = Serialization.convert(data, new TypeReference<Map<String, Object>>(){});
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public <T> T get(String key) {
        return (T)this.data.get(Preconditions.checkNotNull((Object)key, (Object)"Key can't be null"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionData collectionData = (CollectionData)o;
        return Objects.equals(this.id, collectionData.id) && Objects.equals(this.data, collectionData.data);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("data", this.data).toString();
    }
}

