/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.getstream.core.utils.Serialization;
import java.util.Map;
import java.util.Objects;

public class Content {
    private final String foreignID;
    private final Map<String, Object> data = Maps.newHashMap();

    @JsonCreator
    public Content(@JsonProperty(value="foreign_id") String foreignID) {
        this.foreignID = (String)Preconditions.checkNotNull((Object)foreignID, (Object)"ID required");
    }

    public static <T> Content buildFrom(T data) {
        return Serialization.convert(data, Content.class);
    }

    @JsonProperty(value="foreign_id")
    public String getForeignID() {
        return this.foreignID;
    }

    @JsonAnyGetter
    public Map<String, Object> getData() {
        return this.data;
    }

    @JsonAnySetter
    public <T> Content set(String key, T value) {
        Preconditions.checkArgument((!"foreignID".equals(key) ? 1 : 0) != 0, (Object)"Key can't be named 'foreignID'");
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null");
        Preconditions.checkNotNull(value, (Object)"Value can't be null");
        this.data.put(key, value);
        return this;
    }

    public <T> Content from(T data) {
        Preconditions.checkNotNull(data, (Object)"Can't extract data from null");
        Map<String, Object> map = Serialization.convert(data, new TypeReference<Map<String, Object>>(){});
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public <T> T get(String key) {
        return (T)this.data.get(Preconditions.checkNotNull((Object)key, (Object)"Key can't be null"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Content collectionData = (Content)o;
        return Objects.equals(this.foreignID, collectionData.foreignID) && Objects.equals(this.data, collectionData.data);
    }

    public int hashCode() {
        return Objects.hash(this.foreignID, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.foreignID).add("data", this.data).toString();
    }
}

