/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.getstream.core.models.serialization.DataDeserializer;
import io.getstream.core.utils.Serialization;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(using=DataDeserializer.class)
public class Data {
    private final String id;
    private final Map<String, Object> data = Maps.newHashMap();

    public Data(String id) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"ID required");
    }

    public static <T> Data buildFrom(T data) {
        return Serialization.convert(data, Data.class);
    }

    public String getID() {
        return this.id;
    }

    @JsonAnyGetter
    public Map<String, Object> getData() {
        return this.data;
    }

    public <T> Data set(String key, T value) {
        Preconditions.checkArgument((!"id".equals(key) ? 1 : 0) != 0, (Object)"Key can't be named 'id'");
        Preconditions.checkNotNull((Object)key, (Object)"Key can't be null");
        Preconditions.checkNotNull(value, (Object)"Value can't be null");
        this.data.put(key, value);
        return this;
    }

    public <T> Data from(T data) {
        return this.from(Serialization.convert(data, new TypeReference<Map<String, Object>>(){}));
    }

    public Data from(Map<String, Object> map) {
        Preconditions.checkNotNull(this.data, (Object)"Can't extract data from null");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public <T> T get(String key) {
        return (T)this.data.get(Preconditions.checkNotNull((Object)key, (Object)"Key can't be null"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        return Objects.equals(this.id, data.id) && Objects.equals(data, data.data);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.data);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("data", this.data).toString();
    }
}

