/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.models;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import io.getstream.core.utils.Serialization;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public class Reaction {
    private final String id;
    private final Integer appID;
    private final String kind;
    private final String userID;
    private final String activityID;
    private final Map<String, Object> extra;

    private Reaction(Builder builder) {
        this.id = builder.id;
        this.appID = builder.appID;
        this.kind = builder.kind;
        this.userID = builder.userID;
        this.activityID = builder.activityID;
        this.extra = builder.extra;
    }

    public String getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="user_id")
    public String getUserID() {
        return this.userID;
    }

    @JsonProperty(value="activity_id")
    public String getActivityID() {
        return this.activityID;
    }

    @JsonAnyGetter
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reaction reaction = (Reaction)o;
        return Objects.equals(this.id, reaction.id) && Objects.equals(this.appID, reaction.appID) && Objects.equals(this.kind, reaction.kind) && Objects.equals(this.userID, reaction.userID) && Objects.equals(this.activityID, reaction.activityID) && Objects.equals(this.extra, reaction.extra);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.appID, this.kind, this.userID, this.activityID, this.extra);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("appID", (Object)this.appID).add("kind", (Object)this.kind).add("userID", (Object)this.userID).add("activityID", (Object)this.activityID).add("extra", this.extra).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static final class Builder {
        private String id;
        private Integer appID;
        private String kind;
        private String userID;
        private String activityID;
        private Map<String, Object> extra;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder appID(int appID) {
            this.appID = appID;
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder userID(String userID) {
            this.userID = userID;
            return this;
        }

        public Builder activityID(String activityID) {
            this.activityID = activityID;
            return this;
        }

        @JsonAnySetter
        public Builder extraField(String key, Object value) {
            if (this.extra == null) {
                this.extra = Maps.newHashMap();
            }
            this.extra.put(key, value);
            return this;
        }

        @JsonIgnore
        public Builder extra(Map<String, Object> extra) {
            this.extra = extra;
            return this;
        }

        @JsonIgnore
        public Builder fromReaction(Reaction reaction) {
            this.id = reaction.id;
            this.appID = reaction.appID;
            this.kind = reaction.kind;
            this.userID = reaction.userID;
            this.activityID = reaction.activityID;
            this.extra = reaction.extra;
            return this;
        }

        @JsonIgnore
        public <T> Builder fromCustomReaction(T custom) {
            return this.fromReaction(Serialization.convert(custom, Reaction.class));
        }

        public Reaction build() {
            return new Reaction(this);
        }
    }
}

