/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.core.options;

import com.google.common.collect.Lists;
import io.getstream.core.http.Request;
import io.getstream.core.options.RequestOption;
import java.util.List;

public final class Filter
implements RequestOption {
    private final List<OpEntry> ops = Lists.newArrayList();

    public Filter idGreaterThan(String id) {
        this.ops.add(new OpEntry(OpType.ID_GREATER_THEN_OR_EQUAL, id));
        return this;
    }

    public Filter idGreaterThanEqual(String id) {
        this.ops.add(new OpEntry(OpType.ID_GREATER_THEN, id));
        return this;
    }

    public Filter idLessThan(String id) {
        this.ops.add(new OpEntry(OpType.ID_LESS_THEN_OR_EQUAL, id));
        return this;
    }

    public Filter idLessThanEqual(String id) {
        this.ops.add(new OpEntry(OpType.ID_LESS_THEN, id));
        return this;
    }

    @Override
    public void apply(Request.Builder builder) {
        for (OpEntry op : this.ops) {
            builder.addQueryParameter(op.type, op.value);
        }
    }

    private static final class OpEntry {
        String type;
        String value;

        OpEntry(OpType type, String value) {
            this.type = type.toString();
            this.value = value;
        }
    }

    static enum OpType {
        ID_GREATER_THEN_OR_EQUAL("id_gte"),
        ID_GREATER_THEN("id_gt"),
        ID_LESS_THEN_OR_EQUAL("id_lte"),
        ID_LESS_THEN("id_lt");

        private String operator;

        private OpType(String operator) {
            this.operator = operator;
        }

        public String toString() {
            return this.operator;
        }
    }
}

