/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.model.beans;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class MarkedActivity {
    private final List<String> activityIds;

    private MarkedActivity(List<String> ids) {
        this.activityIds = ids;
    }

    public List<String> getActivities() {
        return this.activityIds;
    }

    public boolean hasActivities() {
        if (this.activityIds == null) {
            return false;
        }
        return this.activityIds.isEmpty();
    }

    public String joinActivities() {
        return Joiner.on((String)",").join(this.getActivities());
    }

    public static class Builder {
        private ImmutableList.Builder<String> markedActivity = new ImmutableList.Builder();

        public Builder withActivityId(String id) {
            this.markedActivity.add((Object)id);
            return this;
        }

        public Builder withActivityIds(List<String> ids) {
            this.markedActivity.addAll(ids);
            return this;
        }

        public MarkedActivity build() {
            return new MarkedActivity((List)this.markedActivity.build());
        }
    }
}

