/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.model.feeds;

import io.getstream.client.exception.StreamClientException;
import io.getstream.client.model.activities.BaseActivity;
import io.getstream.client.model.beans.FeedFollow;
import io.getstream.client.model.feeds.Feed;
import io.getstream.client.model.filters.FeedFilter;
import io.getstream.client.repo.StreamRepository;
import io.getstream.client.service.AggregatedActivityServiceImpl;
import io.getstream.client.service.FlatActivityServiceImpl;
import io.getstream.client.service.NotificationActivityServiceImpl;
import io.getstream.client.service.UserActivityServiceImpl;
import java.io.IOException;
import java.util.List;

public class BaseFeed
implements Feed {
    protected final StreamRepository streamRepository;
    protected final String feedSlug;
    protected final String userId;
    private final String id;

    public BaseFeed(StreamRepository streamRepository, String feedSlug, String userId) {
        this.streamRepository = streamRepository;
        this.feedSlug = feedSlug;
        this.userId = userId;
        this.id = feedSlug.concat(":").concat(userId);
    }

    @Override
    public void follow(String feedSlug, String userId) throws IOException, StreamClientException {
        String feedId = String.format("%s:%s", feedSlug, userId);
        this.streamRepository.follow(this, feedId);
    }

    @Override
    public void unfollow(String feedSlug, String userId) throws IOException, StreamClientException {
        String feedId = String.format("%s:%s", feedSlug, userId);
        this.streamRepository.unfollow(this, feedId);
    }

    @Override
    public List<FeedFollow> getFollowers() throws IOException, StreamClientException {
        return this.streamRepository.getFollowers(this, new FeedFilter.Builder().build());
    }

    @Override
    public List<FeedFollow> getFollowers(FeedFilter filter) throws IOException, StreamClientException {
        return this.streamRepository.getFollowers(this, filter);
    }

    @Override
    public List<FeedFollow> getFollowing() throws IOException, StreamClientException {
        return this.streamRepository.getFollowing(this, new FeedFilter.Builder().build());
    }

    @Override
    public List<FeedFollow> getFollowing(FeedFilter filter) throws IOException, StreamClientException {
        return this.streamRepository.getFollowing(this, filter);
    }

    @Override
    public void deleteActivity(String activityId) throws IOException, StreamClientException {
        this.streamRepository.deleteActivityById(this, activityId);
    }

    @Override
    public void deleteActivityByForeignId(String foreignId) throws IOException, StreamClientException {
        this.streamRepository.deleteActivityByForeignId(this, foreignId);
    }

    @Override
    public <T extends BaseActivity> AggregatedActivityServiceImpl<T> newAggregatedActivityService(Class<T> clazz) {
        return new AggregatedActivityServiceImpl<T>(this, clazz, this.streamRepository);
    }

    @Override
    public <T extends BaseActivity> FlatActivityServiceImpl<T> newFlatActivityService(Class<T> clazz) {
        return new FlatActivityServiceImpl(this, clazz, this.streamRepository);
    }

    @Override
    public <T extends BaseActivity> UserActivityServiceImpl<T> newUserActivityService(Class<T> clazz) {
        return new UserActivityServiceImpl(this, clazz, this.streamRepository);
    }

    @Override
    public <T extends BaseActivity> NotificationActivityServiceImpl<T> newNotificationActivityService(Class<T> clazz) {
        return new NotificationActivityServiceImpl(this, clazz, this.streamRepository);
    }

    public String getFeedSlug() {
        return this.feedSlug;
    }

    public String getFeedId() {
        return this.getFeedSlug().concat(this.getUserId());
    }

    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getToken() {
        return this.streamRepository.getToken(this);
    }
}

