/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import io.getstream.client.config.AuthenticationHandlerConfiguration;
import io.getstream.client.config.StreamRegion;
import java.io.IOException;

public class ClientConfiguration {
    private int timeout = 5000;
    private int connectionTimeout = 500;
    private long timeToLive = 3600L;
    private long keepAlive = 3000L;
    private int maxConnections = 20;
    private int maxConnectionsPerRoute = 20;
    private StreamRegion region = StreamRegion.US_EAST;
    private AuthenticationHandlerConfiguration authenticationHandlerConfiguration;

    private static ClientConfiguration fromJsonString(String jsonString) throws IOException {
        Preconditions.checkNotNull((Object)jsonString, (Object)"Input string cannot be null");
        return (ClientConfiguration)new ObjectMapper().readValue(jsonString, (TypeReference)new TypeReference<ClientConfiguration>(){});
    }

    public StreamRegion getRegion() {
        return this.region;
    }

    public void setRegion(StreamRegion region) {
        this.region = region;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public AuthenticationHandlerConfiguration getAuthenticationHandlerConfiguration() {
        return this.authenticationHandlerConfiguration;
    }

    public void setAuthenticationHandlerConfiguration(AuthenticationHandlerConfiguration authenticationHandlerConfiguration) {
        this.authenticationHandlerConfiguration = authenticationHandlerConfiguration;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }
}

