/*
 * Decompiled with CFR 0.152.
 */
package io.getstream.client.model.beans;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class FollowMany {
    @JsonSerialize(contentAs=Entry.class)
    private final List<Entry> entries;

    private FollowMany(List<Entry> entries) {
        this.entries = entries;
    }

    @JsonValue
    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        private String source;
        private String target;

        @JsonCreator
        public Entry(@JsonProperty(value="source") String source, @JsonProperty(value="target") String target) {
            this.source = source;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getTarget() {
            return this.target;
        }

        public void setTarget(String target) {
            this.target = target;
        }
    }

    public static class Builder {
        private ImmutableList.Builder<Entry> followEntries = new ImmutableList.Builder();

        public Builder add(String source, String target) {
            this.followEntries.add((Object)new Entry(source, target));
            return this;
        }

        public Builder addMany(List<Entry> entries) {
            this.followEntries.addAll(entries);
            return this;
        }

        public FollowMany build() {
            return new FollowMany((List)this.followEntries.build());
        }
    }
}

